//Allows the player to frob a candle to turn it off (also responds to WaterStim, KOGas and FireStim
//Replaces the Extinguishable script (we should not use that because it tries to activate a model tweq)
//The default gamesys should have this in an "M-CandleSnuff" metaprop, which also handles the link to the flame particles.
//
//The puff of smoke after snuffing can be changed using the Design Note parameter SnuffSmoke = "some sfx archetype"
//You can also set a delay between snuffing and the smoke appearing. Use the parameter SnuffSmokeDelay = milliseconds
//Some fairly poor default values are set in the metaprop.
class CandleSnuff extends SqRootScript
{
	function OnSim()
	{
		lootTest();
	}
	
	function lootTest()
	{
		if(HasProperty("loot")) //world action script overwrites any loot move action
		{
			SetProperty("FrobInfo", "World Action", 2);
			SetProperty("FrobInfo", "Inv Action", 0);
			SetProperty("FrobInfo", "Tool Action", 0);
		}
	}
	
	function OnFrobWorldEnd()
	{
		SnuffIt();
	}
	
	function OnWaterStimStimulus()
	{
		DouseReact();
	}
	
	function OnKOGasStimulus()
	{
		DouseReact();
	}
	
	function OnFireStimStimulus()
	{
		RelightCandle();
	}
	
	function OnTurnOn()
	{
		lootTest();
		ClearData("PreventDouseReact");
		SetProperty("suspobj", "Is Suspicious", FALSE);
		if(Object.HasMetaProperty(self, "FrobInert"))
			Object.RemoveMetaProperty(self, "FrobInert");
	}
	
	function RelightCandle()
	{
		SendMessage(self, "TurnOn");
	}
	
	function DouseReact()
	{
		if(GetData("PreventDouseReact") == null)
		{
			SnuffIt();
		}
	}
	
	function SnuffIt()
	{
		SetData("PreventDouseReact", 1);
		
		//Turn off light and attached particle effect (AnimLight handles this)
		SendMessage(self, "TurnOff");
		
		SetProperty("suspobj", "Is Suspicious", TRUE);
		SetProperty("suspobj", "Suspicious Type", "candle"); //no schema for this, so no comment from AI
		
		Sound.PlaySchema(self, "CandleSnuff");
		
		//Smoke emitted after snuffing it
		local smokeArchetype = "SnuffSmoke"; //default, user should create this
		local mNumber = DarkGame.GetCurrentMission();
		if(Object.Exists(smokeArchetype + mNumber))
			smokeArchetype = smokeArchetype + mNumber;
		
		//Optional delay before smoke appears
		local delay = 1.0;

		foreach(spLink in Link.GetAllInheritedSingle("ScriptParams", self)) //look at object or parent archetypes
		{
			local data = LinkTools.LinkGetData(spLink, "");
			if(data.find("Smoke") != null)
			{
				smokeArchetype = LinkDest(spLink);
				if(data.find("SmokeDelay") != null)
				{
					local splitUp = split(data, "=");
					local paramDelay = splitUp[1].tofloat();
					delay = paramDelay / 1000.0;
				}
				break;
			}
		}
		
		
		if(Object.Exists(smokeArchetype))
			SetOneShotTimer("Smoke", delay, smokeArchetype);
		
		if(!HasProperty("loot"))
		{
			if(!Object.HasMetaProperty(self, "FrobInert"))
				Object.AddMetaProperty(self, "FrobInert");
		}
		else
		{
			SetProperty("FrobInfo", "World Action", 1);
			SetProperty("FrobInfo", "Inv Action", 0);
			SetProperty("FrobInfo", "Tool Action", 0);
		}
	}
	
	function OnTimer()
	{
		if(message().name == "Smoke")
			createSmoke(message().data);
	}
	
	function createSmoke(smokeArchetype)
	{
		//Get first ParticleAttachement link to this object
		local flamePA = Link.GetOne("ParticleAttachement", 0, self);
		
		//Work out how it's attached.
		local attachType = LinkTools.LinkGetData(flamePA, "Type");
		
		local smoke = Object.Create(smokeArchetype);
		local smokeAttach = Link.Create("DetailAttachement", smoke, self); //DA is better than PA, see next line
		LinkTools.LinkSetData(smokeAttach, "Flags", 1); //Non auto delete - useful for loot objects which disappear when frobbed.
		
		//Attach smoke in same way as flame
		LinkTools.LinkSetData(smokeAttach, "Type", attachType);
		if(attachType == 1) //Vhot
		{	
			//Get Vhot number of flame PA link
			local vhotNo = LinkTools.LinkGetData(flamePA, "vhot #");
			LinkTools.LinkSetData(smokeAttach, "vhot/sub #", vhotNo);
		}
		else if(attachType == 2) //joint, in case someone is crazy or inspired enough to have a flaming AI who gets relit
		{
			local jointNo = LinkTools.LinkGetData(flamePA, "joint");
			LinkTools.LinkSetData(smokeAttach, "joint", jointNo);
		}
		else if(attachType == 3) //submodel
		{
			local subModelNo = LinkTools.LinkGetData(flamePA, "submodel #");
			LinkTools.LinkSetData(smokeAttach, "submodel #", subModelNo);
		}
		
		Link.Destroy(smokeAttach); //Keeps the smoke in its original position if the (loot) candle is stolen by the player.
	}	
}