# Thief 2 - Ornate street lamp v2

This object is a from-scratch build of an ornate street lamp for Thief 2. 
The design is based around triple-housing, cast iron street lamps found
in some areas of St Petersburg, Russia, with the Thief 'technomancy' 
glow ball/particle attachment found on the standard street lamps. 

Version 2 adds more street lamp types, better texturing, and a number of
fixes. 

**IMPORTANT:** This update *requires NewDark*. It should work with any
NewDark version, but if you aren't using the latest version, don't
blame me if unspeakable horrors from beyond time and space decide that
you look crunchy and would go well with ketchup.

The two and three lamp housing versions include additional vhots for 
attaching light markers. If the instructions below are followed, 
additional light fnords will be attached to the street lamps in the 
correct locations, regardless of orientation, and follow the lamps 
if you move them for any reason. It's not quite the same as having
two or three light sources per street lamp object, but it's the 
closest we can get in the Dark engine!

It probably goes without saying that, if you follow these instructions,
plonking down one of the triple-housing street lamps in your mission
will create *three light objects* (plus three particle groups via the
ElectricLampBasic metaprop). If you're pushing light or object limits,
you might want to be cautious.

## Contents
    
The contents of the src folder are not required to use these objects,
if you are not interested in the source for the objects, ignore the 
src directory. 

## Installing

Unpack the archive somewhere, copy the obj directory into your Thief2 
directory. In theory, nothing should be overwritten, if there is a name 
clash, contact me at the address below.

Two versions of the "Blkglas" texture have been provided: the default
version has some metalwork in front of the glass, while the _alt version
does not. If you want to use the version without the detail work, delete
`Blkglas.png` and rename `Blkglas_alt.png` to `Blkglas.png`.

If you intend to use the two or three housing versions of the street lamp,
the first thing you should probably do is create the fnord light archetype
that can be attached to the appropriate fnords with `DetailAttachement` 
links:

- Open the Object Hierarchy window
- Select `Object` &#x25b8; `fnord` &#x25b8; `HackLight` &#x25b8; `OmniLightPoint`
- Click `Add`, enter the name `TWStreetLampLight` 
- Select `Object` &#x25b8; `fnord` &#x25b8; `HackLight` &#x25b8; `OmniLightPoint` &#x25b8; `TWStreetLampLight`
- Click `Edit`
- Add `Renderer` &#x25b8; `LightColor: { 0.17; 0.30 }`
- Add `Renderer` &#x25b8; `Light: { 60.00; 0.00, 0.00, 0.00; 40.00; 0.10; TRUE }`
- Click `Done`

Now you can add the street lamps themselves. The first step is the single
housing lamp:

- Open the Object Hierarchy window
- Select `Object` &#x25b8; `physical` &#x25b8; `Lights` &#x25b8; `lanterns` &#x25b8; `LampPost` &#x25b8; `Streetlamp`
- Click `Add`, enter the name `TWStreetLamp1` [^particleinherit]
- Select `TWStreetLamp1`
- Click `Edit`
- (optional) Add `Object System` &#x25b8; `Immobile: TRUE` [^immobile] 
- (optional) Add `Renderer` &#x25b8; `Runtime Object Shadow: TRUE` [^objshadow]
- Add `Renderer` &#x25b8; `Light: { 60.00; 0.00, 0.00, 0.00; 40.00; 0.10; TRUE }`
- Add `Renderer` &#x25b8; `Transparency (alpha): 1.00`
- Add `Shape` &#x25b8; `Model Name: twstlnt1`
- Click `Done`

For the double-housing lamp, follow these steps:

- Open the Object Hierarchy window
- Select `Object` &#x25b8; `physical` &#x25b8; `Lights` &#x25b8; `lanterns` &#x25b8; `LampPost` &#x25b8; `Streetlamp` &#x25b8; `TWStreetLamp1`
- Click `Add`, enter the name `TWStreetLamp2`
- Select `TWStreetLamp2`
- Click `Edit`
- Add `Shape` &#x25b8; `Model Name: twstlnt2`
- Add `Links` &#x25b8; `~DetailAttachement` (note the `~`!)
- In the `Links` window that appears, click `Add`
- In the `To` field enter `TWStreetLampLight`
- Click `OK`
- Select the new link, click `Edit Data`
- Set `Type: Vhot` and `vhot/sub #: 4`
- Click `OK`
- Click `OK`
- Click `Done`

Finally, the triple-housing street lamp is added by following these steps:

- Open the Object Hierarchy window
- Select `Object` &#x25b8; `physical` &#x25b8; `Lights` &#x25b8; `lanterns` &#x25b8; `LampPost` &#x25b8; `Streetlamp` &#x25b8; `TWStreetLamp1` &#x25b8; `TWStreetLamp2`
- Click `Add`, enter the name `TWStreetLamp3`
- Select `TWStreetLamp3`
- Click `Edit`
- Add `Shape` &#x25b8; `Model Name: twstlnt3`
- Add `Links` &#x25b8; `~DetailAttachement`
- In the `Links` window that appears, click `Add`
- In the `To` field enter `TWStreetLampLight`
- Click `OK`
- Select the new link, click `Edit Data`
- Set `Type: Vhot` and `vhot/sub #: 5`
- Click `OK`
- Click `OK`
- Click `Done`

**Note**: You must ensure that `TWStreetLamp3` is added as a child of 
`TWStreetLamp2` if following the instructions given here. These 
instructions rely on the `~DetailAttachement` of the light fnord 
attached to vhot 4 from `TWStreetLamp2` being inherited by 
`TWStreetLamp3`, so that only the single additional attachment of a
light fnord to vhot 5 is needed in `TWStreetLamp3`. If you do not
follow these instructions, you will need to create the additional
link in `TWStreetLamp3` explicitly.

## Contact Information

Author: Chris <chris@starforge.co.uk>  
(`The Watcher` on the TTLG forums).

Email or PM me if you have problems, want an enhancement or find this 
useful :)

## Legal Blurb

This object and any included original graphics are copyright (c) 2013 
Chris Page and released under the Creative Commons Attribution-ShareAlike
License. To view a copy of this license, visit 

http://creativecommons.org/licenses/by-sa/1.0/ 

or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, 
California 94305, USA.

Essentially this means you can do what you want with it as long as you
include credit and don't try to prevent anyone else from using it or
any derivative of it.

[^particleinherit]: Adding `TWStreetLamp1` to the `Streetlamp` archetype 
means that you get the standard particle ball setup and other settings
inherited from `Streetlamp`.

[^immobile]: These lanterns include internal polygons that will give the 
appearance of the light being blocked by the solid parts of the lamp 
housings if `Object System` &#x25b8; `Immobile` is set to `TRUE`. Some editors 
may not like this effect, and should either explicitly set 
`Object System` &#x25b8; `Immobile` to `FALSE`, or not add the property to the 
archetype. 

[^objshadow]: This only really makes sense in combination with setting
`Object System` &#x25b8; `Immobile` to `TRUE`, in which case the shadows cast
by the lamp housing will affect the light gem. Note that the `Runtime
Object Shadow` property can produce unexpected lighting behaviour in
some situations: you may need to experiment with this!