
//Unfortunately, we can't extend classes from OSM with Squirrel
//
//Let's reproduce the base of potions
//
//First with Food script
class EatFood extends SqRootScript
{
	function OnFrobInvEnd()
	{
		local is_player = (object(message().Frobber) == object("Player")); 
		local loc = is_player ? eEnvSoundLoc.kEnvSoundAmbient : eEnvSoundLoc.kEnvSoundAtObjLoc;
		local zeroes = vector(0,0,0); 
		Object.Teleport(self,zeroes,zeroes,message().Frobber); 
		Sound.PlayEnvSchema(self,"Event Activate",self,message().Frobber,loc);
	}
}

//For AirPotion equivalent for hazard zone
class HazardPotion extends EatFood
{
	function RefillBar(obj)
	{
		local percent = 100;
		local group = -1;
		if("PercentRecovery" in userparams())
			percent = userparams().PercentRecovery;
		if("Group" in userparams())
			group = userparams().Group;
		foreach(l in Link.GetAll("~Population",obj))
		{
			PostMessage(LinkDest(l),"RefillPercent",obj,percent,group);
		}
	}

	function OnFrobInvEnd()
	{
		base.OnFrobInvEnd();
		RefillBar(object(message().Frobber));
	}
}

//Now we can finaly reproduce the base of potions scripts
class TimedPotion extends EatFood
{
  function Subject()
  {
     if(Link.AnyExist("~ScriptParams",self))
        return(LinkDest(Link.GetOne("~ScriptParams",self)));
     return 0;
  }
  function GetHandler(imbiber)
  {
     local handler=0;
     local ctype="";

     if(Property.Possessed(self,"CombineType"))
        ctype=Property.Get(self,"CombineType");

     if(imbiber!=0)
     {
        local potions=Link.GetAll("ScriptParams",imbiber);


		foreach(l in potions)
		{
			local pot = LinkDest(l);
			if((LinkTools.LinkGetData(l,"")=="Potion") && 
			Property.Possessed(pot,"CombineType") &&
			(ctype==Property.Get(pot,"CombineType")))
				handler=pot;
		}
        /*while(potions.AnyLinksLeft())
        {
           local potlink=potions.Link();
           local pot=sLink(potlink).To();
           if((LinkTools.LinkGetData(potlink,""))=="Potion" &&
              Property.Possessed(pot,"CombineType") &&
              ctype==Property.Get(pot,"CombineType"))
              handler=pot;
           potions.NextLink();
        }*/
     }

     if(handler==0)
     {
        handler=Object.BeginCreate(self);
        local newlink=Link.Create("ScriptParams",imbiber,handler);

        LinkTools.LinkSetData(newlink,"","Potion");
        Property.SetSimple(handler,"HasRefs",FALSE);
        Object.EndCreate(handler);
     }
     return handler;
  }
  function PotionEffect(imbiber, start)
  {
     return;
  }
  function OnBeginScript()
  {
     if(Link.AnyExist("~Contains",self))
     {
        local container=LinkDest(Link.GetOne("~Contains",self));
        //Debug.MPrint(self," contained by ",container);
        if(Property.Possessed(container,"AI"))
        {
           if(!Object.HasMetaProperty(container,"M-QuaffHeal"))
              Object.AddMetaProperty(container,"M-QuaffHeal");
        }
     }
  }
  function OnFrobInvEnd()
  {
	 base.OnFrobInvEnd();
     PostMessage(GetHandler(message().Frobber),"StartPotion");
  }
  function OnMessage()
  {
     if(MessageIs("StartPotion"))
     {
        local timeout=8600;
        local potiontimer;
        if(IsDataSet("PotionTimer"))
        {
           potiontimer=GetData("PotionTimer");
           KillTimer(potiontimer);
        }
        if(Property.Possessed(self,"ScriptTiming"))
           timeout=Property.Get(self,"ScriptTiming");
        timeout=timeout-1000;
        if(timeout<0) timeout=0;
		
		SetData("PotionTimeout",timeout);
        PotionEffect(Subject(),TRUE);
        potiontimer=SetOneShotTimer(self,"PreEndPotion",(timeout).tofloat()/1000.0);
        SetData("PotionTimer",potiontimer);
     }
  }
  function OnTimer()
  {
     if(message().name=="EndPotion")
     {
        PotionEffect(Subject(),FALSE);
        ClearData("PotionTimer");
        Object.Destroy(self);
     }
     else if(message().name=="PreEndPotion")
     {
        local potiontimer=SetOneShotTimer(self,"EndPotion",1.0);
        local imbiber=Subject();
        local is_player = (imbiber == object("Player")); 
        local loc = is_player ? eEnvSoundLoc.kEnvSoundAmbient : eEnvSoundLoc.kEnvSoundAtObjLoc;

        SetData("PotionTimer",potiontimer);
        Sound.PlayEnvSchema(self,"Event Deactivate",self,imbiber,loc);
     }
  }
}

// Editor Only Potion in Miss1
//
// Funny mistake made during tests
// for smoke grenades when it was supposed
// to invert controls
class InsanePotion extends TimedPotion
{
	function PotionEffect(imbiber, start)
	{
		if(!Object.InheritsFrom(imbiber,Object.Named("Avatar")))
		 return;
		if(start)
		{
			DrkInv.AddSpeedControl("InsaneBoost",-50,-250);
		}
		else
		{
			DrkInv.RemoveSpeedControl("InsaneBoost");
		}
	}
}

//Spirit potion related scripts - Former scripts names kept to reduce amount of work

//TraceableIA - Now just to define the AIVisions
class TraceableAI extends SqRootScript
{
	function OnBeginScript()
	{
		if(!HasProperty("AI_VisType"))
		{
			SetProperty("AI_VisType",0);
			if(Object.InheritsFrom(self,"Apparition"))
				SetProperty("AI_VisType",1);
		}
	}
}

//Spirit Potion
class TrackingPotion extends TimedPotion
{
	function RemoveAllLinks(kind,imbiber)
	{
		local ls = Link.GetAll(kind,imbiber);
		local l = 0;
		while ( ls.AnyLinksLeft() )
		{
			l = ls.Link();
			if(!Object.InheritsFrom(LinkDest(l),"Apparition"))
				Link.Destroy(l);
			ls.NextLink();
		}
	}
	
	function CheckLight()
	{
		if(IsDataSet("imbiberSpeedCheckTimer"))
		{
			KillTimer(GetData("imbiberSpeedCheckTimer"));
			ClearData("imbiberSpeedCheckTimer");
		}
		local t = SetOneShotTimer("checkimbiberSpeed",0.1);
		SetData("imbiberSpeedCheckTimer",t);
	}
	
	function ClampLight(value)
	{
		if(value > 0)
			return 0;
		return value;
	}
	
	function AdjustLight()
	{
		if(!IsDataSet("NegativeLight"))
				return;
		local negLight = GetData("NegativeLight");
		local imbiber = Subject();
		local imbiberSpeed = vector();
		
		Physics.GetVelocity(imbiber,imbiberSpeed);

		local coefLight = (fabs(imbiberSpeed.x)/10.0 + fabs(imbiberSpeed.y)/7.0 + fabs(imbiberSpeed.z)/12.0);
		local LightPower = ClampLight(-500+500*fabs(coefLight));

		local malus = 1;
		if(IsDataSet("LightMalus"))
			malus = GetData("LightMalus");
		
		Property.SetSimple(negLight,"SelfLit",LightPower * malus);

		if(LightPower < 0)
			ForgetMe(imbiber);
		else
			Property.Set(imbiber,"AI_VisModifier","Vis Type 0 Mod",1);
		
		CheckLight();
	}
	
	function ForgetMe(imbiber)
	{
		//RemoveAllLinks("~AIAwareness",imbiber);
		Property.Set(imbiber,"AI_VisModifier","Vis Type 0 Mod",0.1);
		RemoveAllLinks("~AIAttack",imbiber);
		RemoveAllLinks("~AITarget",imbiber);
	}
	
	function PotionEffect(imbiber, start)
	{
		if(start)
		{	
			if(IsDataSet("NegativeLight"))
				return;
			if(!Object.Exists("M-PlayerInvisible"))
			{
				print("The Metaproperty M-PlayerInvisible doesn't exist, please create it!");
				return;
			}
			Object.AddMetaProperty(imbiber,"M-PlayerInvisible");
			local linkImbiber = Link.Create("ScriptParams",imbiber,self);
			LinkTools.LinkSetData(linkImbiber,"","SpiritPotion");
			
			ForgetMe(imbiber);
			
			local negLight = Object.Create("marker");
			
			Link.Create("~DetailAttachement",imbiber,negLight);
			Property.SetSimple(negLight,"SelfLitRad",1);
			SetData("NegativeLight",negLight);
			AdjustLight();
		}
		else
		{
			if(!Object.Exists("M-PlayerInvisible"))
			{
				print("The Metaproperty M-PlayerInvisible doesn't exist, please create it!");
				return;
			}
			Object.RemoveMetaProperty(imbiber,"M-PlayerInvisible");
			foreach(l in Link.GetAll("ScriptParams",imbiber,self))
			{
				if(LinkTools.LinkGetData(l,"") == "SpiritPotion")
					Link.Destroy(l);
			}
		
			Property.Set(imbiber,"AI_VisModifier","Vis Type 1 Mod",1);
			Property.Set(imbiber,"AI_VisModifier","Vis Type 0 Mod",1);
			
			local negLight = GetData("NegativeLight");
			Object.Destroy(negLight);
			ClearData("NegativeLight");
			
			if(IsDataSet("imbiberSpeedCheckTimer"))
				KillTimer(GetData("imbiberSpeedCheckTimer"));
			ClearData("imbiberSpeedCheckTimer");
			if(!Object.InheritsFrom(imbiber,Object.Named("Avatar")))
				return;
			Sound.PlaySchemaAmbient(imbiber,ObjID("garsigh"));
		}
	}
	
	function OnPlayerIsAttacking()
	{
		SetData("LightMalus",0);
	}
	
	function OnPlayerEndAttack()
	{
		SetData("LightMalus",1);
	}
	
	function OnBeginScript()
	{
		if(!Property.Possessed(self,"ScriptTiming"))
			SetProperty("ScriptTiming",30000);
	}
	
	function OnTimer()
	{
		if(message().name == "checkimbiberSpeed")
			AdjustLight();
		base.OnTimer();
	}
}

class PlayerInvisible extends SqRootScript
{
	function OnEndAttack()
	{
		Link.BroadcastOnAllLinksData(self,"PlayerEndAttack", "ScriptParams", "SpiritPotion");
	}
	
	function OnStartWindup()
	{
		Link.BroadcastOnAllLinksData(self,"PlayerIsAttacking", "ScriptParams", "SpiritPotion");
	}
}


//Slow fall potion recreated
//
//	not planned to be used in the campaign
//	but at least it's here if someone is interested
class LoGravPotion extends TimedPotion
{
	function PotionEffect(imbiber, start)
	{
		if(!Object.InheritsFrom(imbiber,Object.Named("Avatar")))
		 return;
		if(start)
		{
		 vel = vector();
		 Physics.GetVelocity(imbiber,vel);
		 if(vel.z<0) vel.z/=2;
		 Physics.SetVelocity(imbiber,vel);

		 DrkInv.AddSpeedControl("LoGrav",0.5,1.0);
		 Physics.SetGravity(imbiber,0.50);
		}
		else
		{
		 Physics.SetGravity(imbiber,1.00);
		 DrkInv.RemoveSpeedControl("LoGrav");
		}
	}
}

//Strenght potion
//		Sword deals more damage
//		BJ can ko guards NoKO like regular guards
//		BJ can ko guards like servants
//		BJ is lethal for servants
//		Carry sword and body without weight malus
//		Be able to carry heavy dead creatures bodies
//		Be able to slay zombies with your sword
class StrenghtPotion extends TimedPotion
{

	function OnBeginScript()
	{
		if(!Property.Possessed(self,"ScriptTiming"))
			SetProperty("ScriptTiming",20000);
	}
	
	function PotionEffect(imbiber, start)
	{
		if(!Object.InheritsFrom(imbiber,Object.Named("Avatar")))
		 return;
		if(!Object.Exists(Object.Named("M-StrongerPlayer")))
		 return;
		if(start)
			PostMessage(imbiber, "IsStronger", true);
		else
			PostMessage(imbiber, "IsStronger", false);
	}
}




//Base for projectile applying effect on impact
//Fair plagiarism of potion effect script... hopefuly potions won't sue projectiles!
class CollEffectProj extends SqRootScript
{
	//Classic function to know the imbiber
	function Subject()
	{
		if(Link.AnyExist("~ScriptParams",self))
			return(LinkDest(Link.GetOne("~ScriptParams",self)));
		return 0;
	}
	
	function Firer()
	{
		if(Link.AnyExist("Firer",self))
			return(LinkDest(Link.GetOne("Firer",self)));
		return 0;
	}
	
	//Handler : create a ghost copy of the projectile
	//so it manages the timed effect despite the destruction
	//of the original projectile.
	
	//If we're talking about the same object which just spent
	//a stack amount, let's reuse it!
	//This part of the code reusing it tho might be useful since
	//these projectiles are enemy ones. But who knows?
	//
	//When TBP will be out perhaps someone would make good use of it?
	function GetHandler(imbiber)
	{
		local handler=0;
		local ctype="";

		if(Property.Possessed(self,"CombineType"))
			ctype=Property.Get(self,"CombineType");

		if(imbiber!=0)
		{
			local projs=Link.GetAll("ScriptParams",imbiber);

			while(projs.AnyLinksLeft())
			{
			   local projlink=projs.Link();
			   local proj=sLink(projlink).To();
			   if(string(LinkTools.LinkGetData(projlink,""))=="Proj" &&
				  Property.Possessed(proj,"CombineType") &&
				  ctype==Property.Get(proj,"CombineType"))
				  handler=proj;
			   projs.NextLink();
			}
		}

		if(handler==0)
		{
			handler=Object.BeginCreate(self);
			
			//In case we need to know the shooter identity, let's give this copy
			//the Firer link.
			if(Link.AnyExist("Firer",self))
				Link.Create("Firer",handler,LinkDest(Link.GetOne("Firer",self)));
			
			local newlink=Link.Create("ScriptParams",imbiber,handler);

			LinkTools.LinkSetData(newlink,"","Proj");
			Property.SetSimple(handler,"HasRefs",FALSE);
			Property.Set(handler,"PhysType","Type",3);
			Object.EndCreate(handler);
		}
		return handler;
	}
	//Abstract function for effect since this script is a base!
	function ProjEffect(imbiber, start)
	{
		return;
	}
	
	//Let's detect collisions
	function OnBeginScript()
	{
		Physics.SubscribeMsg(self, ePhysScriptMsgType.kCollisionMsg);
	}
	//Do not flood memory when you're dead or back to Edit Mode
	function OnEndScript()
	{
		Physics.UnsubscribeMsg(self, ePhysScriptMsgType.kCollisionMsg);
	}
	//Touched = Effect will happen! Let's prepare the setup!
	function OnStartEffect()
	{
		local timeout=8600;
		local projtimer;
		//Classic block to use one unique timer instead of billions
		if(IsDataSet("ProjTimer"))
		{
		   projtimer=GetData("ProjTimer");
		   KillTimer(projtimer);
		}
		if(Property.Possessed(self,"ScriptTiming"))
		   timeout=Property.Get(self,"ScriptTiming");
		//Obscure reason from LGS to sacrifice one second.
		//Perhaps to force designers to set large timers? Who knows...
		timeout=timeout-1000;
		if(timeout<0) timeout=0;
		
		SetData("ProjTimeout",timeout);
		ProjEffect(Subject(),TRUE);
		projtimer=SetOneShotTimer(self,"PreEndProj",(timeout).tofloat()/1000.0);
		SetData("ProjTimer",projtimer);
	}
	function OnTimer()
	{
		 if(message().name=="EndProj")
		 {
			ProjEffect(Subject(),FALSE);
			ClearData("ProjTimer");
			Object.Destroy(self);
		 }
		 else if(message().name=="PreEndProj")
		 {
			local projtimer=SetOneShotTimer(self,"EndProj",1.0);
			local imbiber=Subject();
			local is_player = (imbiber == object("Player")); 
			local loc = is_player ? eEnvSoundLoc.kEnvSoundAmbient : eEnvSoundLoc.kEnvSoundAtObjLoc;

			SetData("ProjTimer",projtimer);
			Sound.PlayEnvSchema(self,"Event Deactivate",self,imbiber,loc);
		 }
	}
	function OnPhysCollision()
	{
		PostMessage(GetHandler(message().collObj),"StartEffect");
	}
}

class DrawToTarget extends SqRootScript
{
	function Push_C(c)
	{
		if(!IsDataSet("Path"))
			return vector(0);
		SetData("Path", GetData("Path")+";"+ M.VecToString(c));
		return c;
	}
	
	function Shift()
	{
		local path = Pull();
		if(path.len() == 0)
			return [];
		local new = [];
		for(local x=1;x<path.len();x++)
		{
			new.push(path[x]);
		}
		SetData("Path",M.ArrToString(new));
		return path[0];
	}
	
	function Pull()
	{
		if(!IsDataSet("Path"))
			return [];
		return M.StringToArr(GetData("Path"));
	}
	
	function Len()
	{
		local path = Pull();
		return path.len();
	}
	
	function Get(i)
	{
		local path = Pull();
		return M.StringToVec(path[i]);
	}
	
	function Rate()
	{
		return M.max(25, GetProperty("CfgTweqEmit","Rate"));
	}
	
	function Max()
	{
		return M.max(0, GetProperty("CfgTweqEmit","Max frames"));
	}
	
	function Projectile()
	{
		local p = GetProperty("CfgTweqEmit","Emit what");
		if(ObjID(p) != 0)
			return p;
		return ObjID("broadhead");
	}

	function Firer()
	{
		if(Link.AnyExist("Firer",self))
			return LinkDest(Link.GetOne("Firer",self));
		if(IsDataSet("Dad"))
			return GetData("Dad");
		return 0;
	}
	
	function Target()
	{
		local f = Firer();
		if(f == 0)
			return 0;
		if(Link.AnyExist("AITarget",f))
			return LinkDest(Link.GetOne("AITarget",f));
		if(IsDataSet("Foe"))
			return GetData("Foe");
		return 0;
	}
	
	function TargetPos()
	{
		if(Target() > 0)
			return Object.Position(Target());
		return Pos();
	}
	
	function Pos()
	{
		return Object.Position(self);
	}
	
	function LastPos()
	{
		return Get(Len()-1);
	}
	
	function TargetDistOrigin()
	{
		return TargetPos() - Pos();
	}
	
	function TargetDist()
	{
		return TargetPos() - LastPos();
	}
	
	function TargetDirOrigin()
	{
		return (TargetDistOrigin()).GetNormalized();
	}
	
	function TargetDir()
	{
		return (TargetDist()).GetNormalized();
	}
	
	function Draw(coords, dir)
	{
		local p = Object.Create(Projectile());
		local face = M.GetAngleFromDir(dir);
		Push_C( (LastPos()) + dir);
		Object.Teleport(p,coords,face);
		Link.Create("Owns",self, p);
		return p;
	}
	
	function RandomShift()
	{
		local ray = TargetDist().Length() - 1;
		return vector(Data.RandInt(ray * -1, ray),Data.RandInt(ray * -1, ray),Data.RandInt(ray * -1, ray));
	}
	
	function TryToDraw()
	{
		local dir = TargetDir();
		local dist = TargetDist().Length();
		//DarkUI.TextMessage("YEEEAHHH   " + dist,0,1000);
		if(dist > 1)
			dir = ((TargetPos() + RandomShift() ) - LastPos()).GetNormalized();
		
		local proj = Draw(LastPos(),dir);
		
		if((dist > 1 && Max() == 0) || (dist > 1 && Max() > Len()-1))
			SetOneShotTimer("Draw",Rate()/1000);
		else
		{
			ActReact.EndContact(self, Target());
			ActReact.BeginContact(self, Target());
			local vel = vector(0);
			Physics.GetVelocity(Target(),vel);
			Physics.SetVelocity(Target(),vel + TargetDirOrigin()*7);
		}
	}
	
	function OnSlain()
	{
		local ls = Link.GetAll("Owns",self);
		while ( ls.AnyLinksLeft() )
		{
			Damage.Slay(LinkDest(ls.Link()),message().culprit);
			ls.NextLink();
		}
	}
	/*
	function OnMessage()
	{
		DarkUI.TextMessage((message().message));
		print("Object "+self + ":" + message().message);
	}
	*/

	function OnLaunch()
	{
		if(Firer()==0)
			return;
		SetData("Path","");
		SetData("Dad",Firer());
		SetData("Foe",Target());
		Push_C(Pos());
		
		SetOneShotTimer("Draw",Rate()/1000);
	}
	
	function OnTimer()
	{
		if(message().name == "Draw")
			TryToDraw();
	}
}