class BalconyDoorUnlockHint extends SqRootScript
{
	//Only receives message when task 4 has been completed and is then un-completed
	function OnTurnOff()
	{
		SendMessage("DoChoreAgainNote", "TryAgain");
		//local starObject = "Task4Undone";
		//local automapDecal = Property.Get(starObject, "automap", "Location");
		SendMessage("Task4Undone", "TurnOn");
		if(!Link.AnyExist("ControlDevice", "Task4Done", "Task4DoneAgain"))
			Link.Create("ControlDevice", "Task4Done", "Task4DoneAgain");		
	}
}
class DoChoreAgainNote extends SqRootScript
{
	function OnTryAgain()
	{
		if(!DarkGame.GetAutomapLocationVisited(1, 23))
			SendMessage(self, "TurnOn"); //activates the SetNote script
	}
}

class MoveFromForemansOffice extends SqRootScript
{
	function OnObjRoomTransit()
	{
		local destRoomName = Object.GetName(message().ToObjId);
		if(destRoomName == "1: Foreman's Office")
		{
			SetData("GuardInOffice", 1);
		}
		else
		{
			SetData("GuardInOffice", 0);
		}
	}
	
	function OnContained()
	{ //if guard gets the Contained message after being dropped in the office, and while he's still in the office, and is contained by the player (rather than dropped)
		if(DarkGame.GetAutomapLocationVisited(1, 13) && GetData("GuardInOffice") && message().event == eContainsEvent.kContainAdd)
		{
			local t3DoneObject = "Task3Done";
			local t3UndoneObject = "Task3Undone";
			local t3DoneAgainObject = "Task3DoneAgain";
			SendMessage(t3UndoneObject, "TurnOn");
			SendMessage("DoChoreAgainNote", "TryAgain");
			
			if(!Link.AnyExist("ControlDevice", t3DoneObject, t3DoneAgainObject))
				Link.Create("ControlDevice", t3DoneObject, t3DoneAgainObject);
		}
	}
}

class UpdateMapNoteOnCompletion extends SqRootScript
{
	function OnTurnOn()
	{	
		if("MaxLocation" in userparams())
		{	
			SetOneShotTimer("updateMapLoc", 0.2); //delay added to ensure the property is only updated after the current location is made visible
		}
		else
			DarkUI.TextMessage("\"MaxLocation\" param is required in the Design Note property");
	}
	
	function OnTimer()
	{
		if(message().name == "updateMapLoc")
		{
			local limit = userparams().MaxLocation;
			local automapProp = GetProperty("automap", "Location");
			
			if(automapProp < limit)
				SetProperty("automap", "Location", automapProp+1);
		}
	}
}

//This reset the VO links if any of Rubber's Chores get undone and the player tries to leave the IR
class ResetRubbersLinks extends SqRootScript
{
	function OnTurnOff()
	{
		local cdLink = Link.GetOne("ControlDevice", "VOTS5T02", "VOTS5T04");
		Link.Destroy(cdLink);
		
		Link.Create("ControlDevice", "VOTS5T02", "VOTS5T03");
	}
}