class StunOccupants extends SqRootScript
{
	function OnCreatureRoomEnter()
	{
		if(!Link.AnyExist("Population", self, message().MoveObjId))
		{
			Object.AddMetaProperty(message().MoveObjId, "M-NotifyRegion");
			Link.Create("Population", self, message().MoveObjId);
		}
		return 0;
	}
	
	function CreatureRoomExit()
	{
		if(Link.AnyExist("Population", self, message().MoveObjId))
		{
			Object.RemoveMetaProperty(message().MoveObjId, "M-NotifyRegion");
			local lPopLink = Link.GetOne("Population", self, message().MoveObjId);
			Link.Destroy(lPopLink);
		}
	}
	
	function OnMessage()
	{
		if(MessageIs("Obituary"))
		{
			if(Link.AnyExist("Population", self, message().FromObjId))
			{
				Object.RemoveMetaProperty(message().FromObjId, "M-NotifyRegion");
				local lPopLink = Link.GetOne("Population", self, message().FromObjId);
				Link.Destroy(lPopLink);
			}
			return 0;
		}
	}
	
	function OnTurnOn()
	{
		foreach(popLink in Link.GetAll("Population", self))
		{
			ActReact.Stimulate(LinkDest(popLink), "ShockStim", 1.0, self);
		}
		return 0;
	}
}