class SubtitleText extends SqRootScript
{	
	function OnMessage()
	{
		if(MessageIs("VOPlay"))
		{
			local sWidth = int_ref();
			local sHeight = int_ref();	
			Engine.GetCanvasSize(sWidth, sHeight);
			
			local totalTime = 0.0;
			for(local i = 0; i < 10; i++) //assuming no page number > 9
			{
				local pgText = Data.GetString(message().data, "page_" + i, "", "Books");
				if(pgText == "")
					break; //stop after last page
				
				local blankLines = "";
				local numLines = (sHeight.tointeger()/20) - 5;
				
				for(local j = 0; j < numLines; j ++)
				{
					blankLines += "\n";
				}
				
				local timeout = 0;
				local currentPageTime = 0.0;
				local pgTimeStr = Data.GetString(message().data, "page_" + i + "_time", "", "Books");
				if(pgTimeStr != "")
				{
					timeout = pgTimeStr.tointeger() //from page_n_time, milliseconds;
					currentPageTime = pgTimeStr.tofloat();
					totalTime += currentPageTime/1000;
				}
				
				local pgColourStr = Data.GetString(message().data, "page_" + i + "_color", "", "Books");
				
				local pgColour = strToColour(pgColourStr);

				SetOneShotTimer("BookText", totalTime - currentPageTime/1000, blankLines + pgText + "@" + pgColour + "@" + timeout);
			}
		}
	}
	
	function OnTimer()
	{
		if(message().name == "BookText")
		{
			local splitData = split(message().data, "@");
			//Page colour
			local colour = splitData[1].tointeger();
			
			//Page time
			local timeout = DEFAULT_TIMEOUT;
			if(splitData[2] != "0")
				timeout = splitData[2].tointeger();
			
			DarkUI.TextMessage(splitData[0], colour, timeout);
		}
	}
	
	function strToColour(colString) //from str file
	{
		if(colString[0].tochar() == "#")
		{
			if(colString.len() < 6)
				return 0; //white
			
			local lookup = ['0','1','2','3','4','5','6','7','8','9',
                'a','b','c','d','e','f']; //hex values
				
			//Convert html code to RGB (0 - 255 values)
			local red = lookup.find(colString[1]) * 0x10 + lookup.find(colString[2]);
			local green = lookup.find(colString[3]) * 0x10 + lookup.find(colString[4]);
			local blue = lookup.find(colString[5]) * 0x10 + lookup.find(colString[6]);
			
			//Generate colour integer using bitwise OR and bitshifting green and blue
			local colInt = (red | green << 8 | blue << 16);
			return colInt;
		}
		else
			return 0; //white
	}
}