//For testing purposes only
class ReportLinks extends SqRootScript
{
	function OnFrobInvEnd()
	{
		local mainName = Object.GetName(407);
		print("Links from object " + mainName);
		foreach(spLink in Link.GetAll(0, 407))
		{
			local lnk = sLink(spLink);
			local data = LinkTools.LinkGetData(spLink, "");
			
			if(lnk.flavor != 1)
				print(LinkTools.LinkKindName(lnk.flavor) + ": " + Object.GetName(lnk.source) + "(" + lnk.source + ") -> " + Object.GetName(lnk.dest) + "(" + lnk.dest + ") : " + data);
		}
		Sound.PlaySchemaAmbient("Player", "Button_push");
	}
}

//Increment and decrement a persistent variable
function SetData2(name, param)
{
	local value = GetData(name);
	local oldValue = value;
	
	if(value == null)
	{
		value = 0;
		SetData(name, value);	
	}
	
	if(param == "++")
	{
		value++;
		SetData(name, value);
	}
	else if(param == "--")
	{
		if(value > 0)
		{
			value--;
			SetData(name, value);
		}
	}
}

/* SetData does not support arrays. This stores an array's elements as a 
 * string, with each value separated by a ,
*/
function SetDataArray(dataName, array)
{
	local dataString = "";
	for(local i = 0; i < array.len(); i++)
	{
		dataString += array[i];
		if(i < array.len() - 1)
			dataString += ",";
	}
	//DarkUI.TextMessage("Setting Queue: " + dataString);
	SetData(dataName, dataString);
}

/* Gets a value using GetData and returns an array by splitting the value
 * by , and converts the elements to integers.
*/
function GetDataArray(dataName)
{
	local dataString = GetData(dataName);
	local intArray = array(0);
	
	if(dataString)
	{
		local strArray = split(dataString, ",");
		foreach(thing in strArray)
		{
			intArray.append(thing.tointeger());
		}
	}
	return intArray;
}

class VOManager extends SqRootScript
{
	function VOPlay(client, bInit, data)
	{
		local oArc = Object.Named("Schema");
		local schema;
		do
		{
			local msg = bInit? "VOPlay":"VODone";
			//print("VOManager: Querying " + client + " with " + msg + " for schema...");
			schema = SendMessage(client, bInit? "VOPlay":"VODone", data);
			//print("... got " + schema);
			if(!schema)
				return 0;
			
			if(schema == client)
			{
				SetData("m_PendingSchema", schema);
				return 0;
			}
			
			local p = Object.InheritsFrom(schema, oArc);
			if(p)
				break;
			//print(p?"Object is schema":"Object is not schema");
			bInit = true;
			client = schema;
		}
		while(true)
		
		local strSchema = Object.GetName(schema);
		if(strSchema == "" || strSchema == null)
		{
			print("This may seem odd, but I'd rather not play a schema without a name.");
			return 0;
		}
		
		local bResult = Sound.PlaySchemaAmbient(self, schema);
		if(!bResult)
		{
			print("Bloody hell, the sound didn't play. Now what do I do?");
			return 0;
		}
		PostMessage(self, "VOPlay", strSchema);
		PostMessage("SubtitleManager", "VOPlay", strSchema);
		
		SetData("m_PendingSchema", 0);
		return client;
	}
	
	function NextVO()
	{
		if(GetDataArray("m_SchemaQueue").len() > 0)
		{
			while (GetDataArray("m_SchemaQueue").len() > 0)
			{
				local schQueue = GetDataArray("m_SchemaQueue");
				local client = schQueue[0];
				schQueue.remove(0);
				SetDataArray("m_SchemaQueue", schQueue);
				SetData("m_CurrentSchema", VOPlay(client, true, ""));
				if(GetData("m_CurrentSchema"))
				{
					break;
				}
			}
		}
		else
		{
			SetData("m_CurrentSchema", 0);
		}
	}
	
	/*
	function OnBeginScript()
	{
		SetData("m_Pausing") //null
		SetData("m_CurrentSchema", 0);
		SetData("m_PendingSchema", 0);
		local schQueue = array(0);
		SetDataArray("m_SchemaQueue", schQueue);
		return 0;
	}
	*/
	
	function OnSim()
	{
		if(message().starting)
		{
			SetData("m_Pausing") //null
			SetData("m_CurrentSchema", 0);
			SetData("m_PendingSchema", 0);
			local schQueue = array(0);
			SetDataArray("m_SchemaQueue", schQueue);
		}
		return 1;
	}
	
	function OnTimer()
	{
		if(message().name != "VOPause")
		{
			return 1;
		}
		
		SetData("m_Pausing"); //null
		NextVO();
		return 0;
	}
	
	function OnSchemaDone()
	{
		local curSchema = GetData("m_CurrentSchema");
		if(!curSchema)
			return 0;
			
		if(message().name != "calibrate1s")
		{
			curSchema = VOPlay(curSchema, false, message().name);
			SetData("m_CurrentSchema", curSchema);
			if(curSchema)
			{
				return 0;
			}
			
			local iPause = 1000;
			if(HasProperty("ScriptTiming"))
			{
				local mpProp = Property.Get(self, "ScriptTiming");
				iPause = mpProp.tointeger();
			}
			if(iPause > 0)
			{
				//print("VOManager: Schemas will resume in " + iPause + "ms");
				SetData("m_Pausing", SetOneShotTimer("VOPause", iPause/1000));
				//print(GetData("m_Pausing"));
			}
			else
			{
				NextVO();
			}
		}
		return 0;
	}
	
	function OnMessage()
	{
		if(MessageIs("VOQueue"))
		{
			local client = message().from;

			if(GetData("m_PendingSchema") == client)
			{
				if(GetData("m_CurrentSchema"))
				{
					//print("Queueing schema " + client);
					local schQueue = GetDataArray("m_SchemaQueue");
					schQueue.append(client);
					SetDataArray("m_SchemaQueue", schQueue);
				}
				else
				{
					if(GetData("m_Pausing"))
					{
						KillTimer(GetData("m_Pausing"));
						SetData("m_Pausing"); //null
					}
					SetData("m_CurrentSchema", VOPlay(client, false, ""));
				}
			}
			else
			{;
				if(GetData("m_CurrentSchema") || GetData("m_Pausing"))
				{
					//print("Queueing schema " + client);
					local schQueue = GetDataArray("m_SchemaQueue");
					schQueue.append(client);
					SetDataArray("m_SchemaQueue", schQueue);
				}
				else
				{	
					SetData("m_CurrentSchema", VOPlay(client, true, ""));
				}
			}
			
			Reply(1);
			return 0
		}
		else if(MessageIs("VOCancel"))
		{
			local client = message().from;
			local schQueue = GetDataArray("m_SchemaQueue");
			local nPos = schQueue.find(client);
			if(nPos >= 0)
			{
				schQueue.remove(nPos);
				SetDataArray("m_SchemaQueue", schQueue);
			}
			if(GetData("m_PendingSchema") == client)
			{
				SetData("m_PendingSchema", 0);
			}
			return 0;
		}
	}
}

class VOClient extends SqRootScript
{
	function OnMessage()
	{
		if(MessageIs("VOPlay"))
		{
			local iSchema = VOPlay();
			ReplyWithObj(iSchema);
		}
		else if(MessageIs("VODone"))
		{
			local iSchema = VODone(message().data);
			ReplyWithObj(iSchema);
		}
		else if(MessageIs("Reset"))
		{
			ResetSchemas();
		}
		
		return 0;
	}
	
	function OnTimer()
	{
		if(message().name != "VODelay")
		{
			return 1;
		}
		
		VODelay(message().data);

		return 0;
	}
	
	function OnTurnOn()
	{
		if(Property.Possessed(self, "TrapFlags"))
		{
			local mp = Property.Get(self, "TrapFlags");
			local count = GetData("m_iEnqueueCount");
			
			if(mp && TRAPF_ONCE)
			{
				if(count > 0)
				{
					return 1;
				}
			}
		}
		Trigger("0:"); //always trigger 0: SP links
		
		ResetSchemas();
		local iSchema = GetSchema(true);
		if(iSchema)
		{
			if(!VOQueue(iSchema)) //trigger 1: and 2: SP links if no SD links
			{
				Trigger("1:");
				Trigger("2:");
			}
		}
		
		return 0;
	}
	
	function OnTurnOff()
	{
		if(!GetData("m_iNowPlaying"))
		{
			VOCancel(0);
		}
		
		return 0;
	}
	
	function Trigger(param)
	{
		local len = param.len();
		
		foreach(spLink in Link.GetAll("ScriptParams", self))
		{
			local lData = LinkTools.LinkGetData(spLink, "");
			if(lData && lData.find(param) == 0)
			{
				PostMessage(LinkDest(spLink), lData.slice(len));
			}
		}
	}
	
	function SetDelay(pause, pszSchema)
	{
		SetOneShotTimer("VODelay", pause, pszSchema); //schema uses seconds, not milliseconds
	}
	
	function ResetSchemas()
	{
		foreach(spLink in Link.GetAll("ScriptParams", self))
		{
			local data = LinkTools.LinkGetData(spLink, "")	
			if(!data)
			{
				Link.Destroy(spLink);
			}
		}
		
		local chain = LinkDest(Link.GetOne("ControlDevice", self));
		if(chain)
		{
			SendMessage(chain, "Reset");
		}
	}
	
	function GetSchema(bQueryOnly)
	{
		local iDest = 0;
		foreach(sdLink in Link.GetAll("SoundDescription", self))
		{
			//is there an SP link from this object to the dest of the SD link?
			local dest = LinkDest(sdLink);
			if(!Link.AnyExist("ScriptParams", self, dest))
			{
				iDest = dest;
				break;
			}
		}
		if(iDest && !bQueryOnly)
		{
			Link.Create("ScriptParams", self, iDest);
		}
		return iDest;
	}
	
	function VOQueue(iSchema)
	{
		local iVO = Object.Named("VOManager");
		if(!iVO)
			return false;
		
		SetData2("m_iEnqueueCount", "++");
		
		local mpReply = SendMessage(iVO, "VOQueue", iSchema);
		
		local boolReply = mpReply;
		
		if(!boolReply)
		{
			SetData2("m_iEnqueueCount", "--");
		}
		return boolReply;
	}
	
	function VOPlay()
	{
		local iSchema = GetSchema(false);
		
		if(iSchema)
		{
			SetData("m_iNowPlaying", 1);
			Trigger("1:");
			return iSchema
		}
		else
		{
			if (GetData("m_iEnqueueCount") > 0)
				SetData2("m_iEnqueueCount", "--");
			local chain = LinkDest(Link.GetOne("ControlDevice", self));
			if(chain)
				return chain;
		}
		return 0;
	}
	
	function VODone(pszSchema)
	{
		local next = GetSchema(false);
		if(next)
			return next;
		
		if(GetData("m_iEnqueueCount") > 0)
			SetData2("m_iEnqueueCount", "--");
		SetData("m_iNowPlaying", 0);
		
		local chain = LinkDest(Link.GetOne("ControlDevice", self));
		if(chain)
			next = chain;
		
		local iPause = 0;
		if(HasProperty("ScriptTiming"))
		{
			iPause = Property.Get(self, "ScriptTiming");
		}
		if(iPause > 0)
		{
			SetDelay(iPause, pszSchema);
		}
		else
		{
			Trigger("2:");
		}
		return next;
	}
	
	function VODelay(pszSchema)
	{
		Trigger("2:");
	}
		
	function VOCancel(iSchema)
	{
		if(GetData("m_iEnqueueCount") > 0)
		{
			local iVO = Object.Named("VOManager");
			if(iVO)
			{
				SendMessage(iVO, "VOCancel", iSchema);
			}
			SetData2("m_iEnqueueCount", "--");
		}
	}
}

class ConvMask extends VOClient
{
	function OnTurnOn()
	{	
		local iPlayer = Object.Named("Player");
		local bContained = Link.AnyExist("Contains", iPlayer, self);
		if(!bContained)
		{
			Link.Create("Contains", iPlayer, self);
		}
		return 0;
	}
	
	function OnTurnOff()
	{
		local iPlayer = Object.Named("Player");
		local bContained = Link.AnyExist("Contains", iPlayer, self);
		if(bContained)
		{
			local lCont = Link.GetOne("Contains", iPlayer, self);
			Link.Destroy(lCont)
			
			if(!HasProperty("HasRefs"))
			{
				Property.Add(self, "HasRefs");				
			}
			Property.SetSimple(self, "HasRefs", 0);
		}
		
		return 0;
	}
	
	function OnFrobInvEnd() 
	{
		OnTurnOff();
		Trigger("0:");
		ResetSchemas();
		local iSchema = GetSchema(true);
		if(iSchema)
		{
			if(!VOQueue(iSchema))
			{
				Trigger("1:");
				Trigger("2:");
			}
		}
		return 0;
	}
	
	
	function OnMessage()
	{
		if(MessageIs("Slay"))
			Object.Destroy(self);
		else
		 base.OnMessage();
	}
	
}

class ConvMask2 extends ConvMask
{
	function OnFrobInvEnd()
	{
		OnTurnOff();
		Trigger("0:");
		ResetSchemas();
		return 0
	}
}

class VORouter extends VOClient
{
	function OnMessage()
	{
		if(MessageIs("Route"))
		{
			foreach(lkCD in Link.GetAll("ControlDevice", self))
			{
				Link.Destroy(lkCD);
			}
			Link.Create("ControlDevice", self, message().from);
			
			if(GetData("m_iVODone"))
			{
				VOQueue(message().from);
			}
			return 0;
		}
		else 
			 base.OnMessage();
	}
	
	/*
	function OnBeginScript()
	{
		SetData("m_iVODone", 0);
	}
	*/
	
	function VODone(pszSchema)
	{
		if(GetData("m_iVODone"))
		{
			SetData("m_iVODone", 0);
			local next = 0;
			local lChain = Link.GetOne("ControlDevice", self);
			if(lChain)
			{
				next = LinkDest(lChain);
				Link.Destroy(lChain);
			}
			return next;
		}
		
		local next = base.VODone(pszSchema);
		if(!next)
		{
			SetData("m_iVODone", 1);
			next = self;
		}
		return next;
	}
	
	function VOPlay()
	{
		if(GetData("m_iVODone"))
		{	
			SetData("m_iVODone", 0);
			local next = 0;
			local lChain = Link.GetOne("ControlDevice", self);
			if(lChain)
			{
				next = LinkDest(lChain);
				Link.Destroy(lChain);
			}
			return next;
		}
		local result = base.VOPlay();
		return result;
	}
	
	function VOCancel(iSchema)
	{
		SetData("m_iVODone", 0);
		foreach(cdLink in Link.GetAll("ControlDevice", self))
		{
			Link.Destroy(cdLink);
		}
		base.VOCancel(iSchema);
	}
}

class MultiVOTrap extends VOClient
{
	/*
	function OnBeginScript()
	{
		SetData("m_bTurnedOn", 0);
		return 1;
	}
	*/

	function OnTurnOn()
	{
		if(!GetData("m_bTurnedOn"))
		{
			SetData("m_bTurnedOn", 1);
			ResetSchemas();
			
			local iPause = 1;
			if(HasProperty("ScriptTiming"))
			{
				local mpProp = Property.Get(self, "ScriptTiming");
				iPause = mpProp.tointeger();
				if(iPause < 1)
					iPause = 1;
			}
			SetDelay(iPause, "");
		}
		return 0;
	}
	
	function OnTurnOff()
	{
		if(GetData("m_bTurnedOn") != 0)
			SetData("m_bTurnedOn", 0);
		
		return 0;
	}
	
	function VOPlay()
	{
		if(GetData("m_bTurnedOn"))
		{
			return GetSchema(false);
		}
		return 0;
	}
	
	function VODone(pszSchema)
	{
		local iSchema = Object.Named(pszSchema);
		
		if(GetData("m_bTurnedOn"))
		{
			local iPause = 1;
			if(Property.Possessed(pszSchema, "ScriptTiming"))
			{
				local mpProp = Property.Get(pszSchema, "ScriptTiming");
				iPause = mpProp.tointeger();
				if(iPause < 1)
					iPause = 1;
			}
			else
			{
				if(HasProperty("ScriptTiming"))
				{
					local mpProp = Property.Get(self, "ScriptTiming");
					iPause = mpProp.tointeger();
					if(iPause < 1)
						iPause = 1;
				}
			}
			
			SetDelay(iPause, pszSchema);
		}
		return 0;
	}
	
	function VODelay(pszSchema)
	{
		if(GetData("m_bTurnedOn"))
		{
			if(pszSchema) //source also checks for *pszSchema
			{
				foreach(lnk in Link.GetAll("ScriptParams", self))
				{
					local psz = LinkTools.LinkGetData(lnk, "");
					if(psz && psz == pszSchema)
					{
						PostMessage(LinkDest(lnk), "TurnOn");
					}
				}
			}
		}
		
		local iSchema = GetSchema(true);
		if(iSchema)
		{
			VOQueue(iSchema);
		}
	}
}