class AllScripts extends SqRootScript
{
	function OnSim()
	{		
		if(message().starting)
			ListScripts(self);
	}
	
	function ListScripts(ob)
	{	
		local sProp = "scripts";
		if(Property.Possessed(ob, sProp))
		{
			local s0 = Property.Get(ob, sProp, "Script 0");
			local s1 = Property.Get(ob, sProp, "Script 1");
			local s2 = Property.Get(ob, sProp, "Script 2");
			local s3 = Property.Get(ob, sProp, "Script 3");
			local dontInherit = Property.Get(ob, sProp, "Don't Inherit");
			
			if(s0 != "") print(s0);
			if(s1 != "") print(s1);
			if(s2 != "") print(s2);
			if(s3 != "" && s3 != "AllScripts") print(s3);
			
			foreach(link in Link.GetAll("MetaProp", ob))
			{
				local mp = sLink(link);
				if(!dontInherit)
					ListScripts(mp.dest);
			}
		}
	}
}

class AllLinks extends SqRootScript
{
	function OnSim()
	{
		if(message().starting)
		{
			ListLinks(self);
		}
	}
	
	function ListLinks(ob)
	{	
		foreach(link in Link.GetAll("MetaProp", ob))
		{
			local l = sLink(link);
			print("arch: " + l.dest);
			ListLinks(l.dest);
		}
	}
}

class SPLinks extends SqRootScript
{
	function OnSim()
	{
		foreach(link in Link.GetAll("ScriptParams"))
		{
			local data = (LinkTools.LinkGetData(link, "")).tostring();
			local spLink = sLink(link);
			print(spLink.source + " -> " + spLink.dest + "_" + data);
		}
	}
}