function noCopyObj()
{
	return "NoCopyKit";
}

class SelectItems extends SqRootScript
{
	function OnTurnOn()
	{			
		local book = message().from;
		local lID = Link.GetOne("ScriptParams", book, self);
		local data = LinkTools.LinkGetData(lID, "");
		
		local writingSetFound = false; //initial value
		//Does the player have a contains link to an instance of "WritingSet" (link data)?
		foreach(cLink in Link.GetAll("Contains", "Player"))
		{
			local dest = LinkDest(cLink);
			if(Object.InheritsFrom(dest, data))
			{
				writingSetFound = true;
				DarkUI.InvSelect(dest);
				break;
			}
		}
		
		if(!writingSetFound)
		{
			if(!Link.AnyExist("Contains", "Player", noCopyObj()))
				Link.Create("Contains", "Player", noCopyObj());
			
			DarkUI.InvSelect(noCopyObj()); //in case player does not have auto selcet turned on
			SetOneShotTimer("HideWarning", 5.0);
		}
	}
	
	function OnTimer()
	{
		if(message().name == "HideWarning")
		{
			Link.Destroy(Link.GetOne("Contains", "Player", noCopyObj()));
			Property.Set(noCopyObj(), "HasRefs", "", 0);
		}
	}
}