class VarLight extends SqRootScript
{
	function ChangeLevel(iLevel)
	{
		SetData("m_iCurLevel", iLevel);
		local afLevel = GetDataArray("m_afLevel");
		Property.Set(self, "AnimLight", "min brightness", afLevel[iLevel]);
		if(!Locked.IsLocked(self))
		{
			Light.SetMode(self, ANIM_LIGHT_MODE_MINIMUM);
			SendMessage(self, "LightChange");
		}
	}
	
	function OnBeginScript()
	{
		local m_afSelfLit = [0.0, 1.375, 1.5, 1.625, 1.75, 1.875, 1.875];
		SetDataArray("m_afSelfLit", m_afSelfLit);
		
		local ltParam = split(userparams().varlight, ",");
		local afLevel = array(7);
		
		for(local i = ltParam.len() -1, j = 0; i >= 0; i--, j++)
		{
			afLevel[i] = ltParam[j].tofloat();
		}
		
		SetDataArray("m_afLevel", afLevel);
		//SetData("m_iCurLevel", -1);
		
		return 0;
	}
	
	function OnSim()
	{	
		if(message().starting)
		{
			SetData("m_iCurLevel", 5);
			
			local afLevel = GetDataArray("m_afLevel");
			Property.Set(self, "AnimLight", "min brightness", afLevel[5]);
			
			if(Locked.IsLocked(self))
			{
				Light.SetMode(self, ANIM_LIGHT_MODE_EXTINGUISH);
				SendMessage(self, "LightChange");
			}
		}
		else
		{
			Light.SetMode(self, ANIM_LIGHT_MODE_MINIMUM);
			SendMessage(self, "LightChange");
		}
		
		return 1;
	}
	
	function OnTimer()
	{
		if(message().name == "ReallySlay")
		{
			Damage.Slay(self, 0);
		}
		else if(message().name == "Overload")
		{
			SetData("m_iCurLevel", 0);
			Light.SetMode(self, ANIM_LIGHT_MODE_MINIMUM);
			SendMessage(self, "LightChange");
			
			SetProperty("SlayResult", "Effect", 0);
			SetProperty("DeathStage", "", 0);
			
			local mpProp = GetProperty("AnimLight", "millisecs to dim");
			local delay = mpProp.tofloat() / 1000 + 0.001;
			SetOneShotTimer("ReallySlay", delay);
			return 0;
		}
		return 1;
	}
	
	function OnSlain()
	{
		if(GetData("m_iCurLevel") > 0)
		{
			local afLevel = GetDataArray("m_afLevel");
			SetData("m_iCurLevel", 6);

			SetProperty("AnimLight", "max brightness", afLevel[6]);
			SetProperty("AnimLight", "min brightness", afLevel[0]);
			
			Light.SetMode(self, ANIM_LIGHT_MODE_MAXIMUM);
			SendMessage(self, "LightChange");
			
			local mpProp = GetProperty("AnimLight", "millisecs to brighten");
			if(HasProperty("ScriptTiming"))
			{
				mpProp = GetProperty("ScriptTiming", "");
			}
			local delay = mpProp.tofloat() / 1000 + 0.001;
			
			SetOneShotTimer("Overload", delay);
		}
		return 0;
	}
	
	function OnTurnOn()
	{
		local curLevel = GetData("m_iCurLevel");
		if(curLevel > 1)
		{
			ChangeLevel(curLevel - 1);
		}
		return 0;
	}
	
	function OnTurnOff()
	{
		local curLevel = GetData("m_iCurLevel");
		if(curLevel > 0 && curLevel < 5)
		{
			ChangeLevel(curLevel + 1);
		}
		return 0;
	}
	
	function OnNowLocked()
	{
		if(GetData("m_iCurLevel") != 0)
		{
			Light.SetMode(self, ANIM_LIGHT_MODE_EXTINGUISH);
			SendMessage(self, "LightChange");
		}
		return 0;
	}
	
	function OnNowUnlocked()
	{
		if(GetData("m_iCurLevel") != 0)
		{
			Light.SetMode(self, ANIM_LIGHT_MODE_MINIMUM);
			SendMessage(self, "LightChange");
		}
		return 0;
	}
	
	function OnMessage()
	{
		if(MessageIs("LightChange"))
		{
			if(!HasProperty("SelfIllum"))
			{
				return 0;
			}
			local mp;
			if(Light.GetMode(self) == ANIM_LIGHT_MODE_EXTINGUISH)
			{
				mp = 0.0;
			}
			else
			{
				local selfLit = GetDataArray("m_afSelfLit");
				mp = selfLit[GetData("m_iCurLevel")];
			}
			SetProperty("SelfIllum", "", mp);
			return 0;
		}
	}
}