class TrapLinks extends SqRootScript
{
	function OnTurnOn()
	{
		local lNew;
		local lOld;
		local iSource;
	
		//Get first CD link	
		local cdLink = Link.GetOne("ControlDevice", self, 0);
		//if none found, abort
		if(cdLink == null)
		{
			Debug.MPrint("No source object. Aborting");
			return 0;
		}
		//continue if CD link found

		//source for link ops
		iSource = LinkDest(cdLink);

		foreach(spLink in Link.GetAll("ScriptParams", self))
		{
			//get data
			local data = strip(LinkTools.LinkGetData(spLink, "")); //data with no accidental whitespace
			
			local firstChar = data.slice(0, 1); //could be @ = - or +
			local atPosition = data.find("@");
			if(atPosition == 0 || atPosition == null)
				continue;
			
			//get flavour and convert shortcuts to full names
			local flavCode = data.slice(atPosition + 1); //could be CD, SP etc, or full flavour name
			local flavour;
			if(flavCode == "CD")
				flavour = "ControlDevice";
			else if(flavCode == "SP")
				flavour = "ScriptParams";
			else if(flavCode == "SD")
				flavour = "SoundDescription";
			else
				flavour = flavCode;
			
			local iDest = LinkDest(spLink);
			
			//does proposed link already exist?
			local bExists = Link.AnyExist(flavour, iSource, iDest);
			local char2 = data.slice(1,2);
			
			switch(firstChar)
			{
				case "=":
					if (!bExists)
					{
						
						if(char2 == "*") //create link from source to arg, remove all old links from source with matching flavour
						{
							//Copy link
							lOld = Link.GetOne(flavour, iSource)
							lNew = Link.Create(flavour, iSource, iDest);
							
							local oldData = LinkTools.LinkGetData(lOld, "");
							if(oldData != 0) //0 is for CD and SD links
								LinkTools.LinkSetData(lNew, "", oldData);
							
							//Delete old links
							foreach(oldLink in Link.GetAll(flavour, iSource))
							{
								if(oldLink != lNew)
									Link.Destroy(oldLink);
							}
						}
						//ignoring alternate argument - never used in MX
					}
				break;
				case "+": //add link from source to arg
					if(!bExists)
					{
						Link.Create(flavour, iSource, iDest);
					}
				break;
				case "-":
					if(char2 == "*") //remove any link from source
					{
						foreach(link in Link.GetAll(flavour, self))
						{
							Link.Destroy(link);
						}
					}
					else if(bExists) //remove link from source to arg if it exists
					{
						lOld = Link.GetOne(flavour, iSource, iDest);
						Link.Destroy(lOld);
					}
				break;
			}
		}
	}
}