class TrapMagicWord extends SqRootScript
{
    /* TrapMagicWord: Puzzle that requires the player to frob several levers in order to spell a word.

        1. Create a TrigTrap object and give it the TrapMagicWord script.

        2. Edit the Editor > Design Note property, and set MagicWord to the solution.

        3. Create one lever for each letter in the magic word.

        4. With each lever:
            a) Add a ControlDevice link to the TrapMagicWord object.
            b) Add a ScriptParams link to the TrapMagicWord object, and
               set its data to the letter for this lever.

        5. Add one or more ControlDevice links from the TrapMagicWord to other objects. It will send
           them TurnOn when the player solves the puzzle, and TurnOff when the puzzle resets.
    */

    // -- Messages

    function OnTurnOn()
    {
        local lever = message().from;
        local link = Link.GetOne(linkkind("ScriptParams"), lever, self);
        local data = LinkTools.LinkGetData(link, "").tostring();
        AdvancePuzzle(data);
    }

    function OnTurnOff()
    {
        ResetPuzzle();
    }

    function OnEnableFrob()
    {
        local thingamabob = message().from;
        if (HasProperty("FrobInfo"))
        {
            SetProperty("FrobInfo", "World Action", ["Move"]);
        }
    }

    // -- Puzzle logic

    function AdvancePuzzle(value)
    {
        local progress = GetProgress();
        local solution = GetSolution();

        print("MagicWord: '" + progress + "' + '" + value + "'");

        if (progress.len() < solution.len()) {
            // Advance the progress
            progress += value;
            SetProgress(progress);

            if (progress.len() <= solution.len()) {
                local partial_solution = solution.slice(0, progress.len());
                if (progress == solution) {
                    // The player spelt the whole magic word.
                    CompletePuzzle();
                } else if (progress == partial_solution) {
                    // On the right track, so do nothing yet.
                } else {
                    // Got the wrong letter.
                    ResetPuzzle();
                }
            } else {
                // Shouldn't be able to get here, but reset
                // the puzzle just in case.
                ResetPuzzle();
            }
        }
    }

    function CompletePuzzle()
    {
        Link.BroadcastOnAllLinks(self, "TurnOn", "ControlDevice");
        Link.BroadcastOnAllLinks(self, "EnableFrob", "ControlDevice");
        Object.Destroy(self);
    }

    function ResetPuzzle()
    {
        SetProgress("");
        TurnOffLevers();
        Link.BroadcastOnAllLinks(self, "TurnOff", "ControlDevice");
    }

    // -- Interaction with other objects

    function TurnOffLevers()
    {
        Link.BroadcastOnAllLinks(self, "TurnOff", "~ControlDevice");
    }

    // -- Data management

    function GetSolution()
    {
        if ("MagicWord" in userparams()) {
            return userparams().MagicWord.tostring();
        } else {
            print("ERROR: No MagicWord given for TrapMagicWord on " + self + ", using default.");
            return "XYZZY";
        }
    }

    function GetProgress()
    {
        if (IsDataSet("MagicWordProgress")) {
            return GetData("MagicWordProgress").tostring();
        } else {
            return "";
        }
    }

    function SetProgress(progress)
    {
        SetData("MagicWordProgress", progress);
    }
}
