enum eAmbienceProgress {
    kMissionStart,
	kAlarmRung,
    kAllDoneNow,
    // The number of progress states
    kCount,
}

class AmbienceController extends SqRootScript
{
    /* Put this on a marker named 'AmbienceController'. */

    REGIONS = {
        STREETS = [
            /* start */    ["HW_Night", "m17wind2"],
            /* alarm */    ["HW_Night", "m17wind2"],
            /* all done */ ["HW_Night", "m17wind2"],
        ],
        GREENHOUSE = [
            /* start */    ["m02tiles", "m06choirLo"],
            /* alarm */    ["m02tiles", "m06choirLo"],
            /* all done */ ["m02tiles", "m06choirLo"],
        ],
        GOLDMANS = [
            /* start */    ["m02tiles", "m17bshit"],
            /* alarm */    ["m02tiles", "m17bshit"],
            /* all done */ ["m02tiles", "m17bshit"],
        ],
        WESTMANS = [
            /* start */    ["m02tiles", "m17wind2"],
            /* alarm */    ["m02tiles", "m17wind2"],
            /* all done */ ["m02tiles", "m17wind2"],
        ],
        BASICMANS = [
            /* start */    ["m02tiles"],
            /* alarm */    ["m02tiles"],
            /* all done */ ["m02tiles"],
        ],
        BLUEMANS = [
            /* start */    ["m02tiles", "m02btrem"],
            /* alarm */    ["m02tiles", "m02btrem"],
            /* all done */ ["m02tiles", "m02btrem"],
        ],
        NEMANS = [
            /* start */    ["m02tiles", "m02tones"],
            /* alarm */    ["m02tiles", "m02tones"],
            /* all done */ ["m02tiles", "m02tones"],
        ],
        GRAYMANS = [
            /* start */    ["m02tiles", "m00_TensKpr"],
            /* alarm */    ["m02tiles", "m00_TensKpr"],
            /* all done */ ["m02tiles", "m00_TensKpr"],
        ],
        GREENMANS = [
            /* start */    ["m02tiles", "m17bsstr"],
            /* alarm */    ["m02tiles", "m17bsstr"],
            /* all done */ ["m02tiles", "m17bsstr"],
        ],
        FACTORY = [
            /* start */    ["m02abyss", "m15tones"],
            /* alarm */    ["m02abyss", "m15tones"],
            /* all done */ ["m02abyss", "m15tones"],
        ],
        BUTCHER = [
            /* start */    ["HW_Night", "guildhits"],
            /* alarm */    ["HW_Night", "guildhits"],
            /* all done */ ["HW_Night", "guildhits"],
        ],
        KEEPER = [
            /* start */    ["m07organ"],
            /* alarm */    ["m07organ"],
            /* all done */ ["m07organ"],
        ],
        STREETS2 = [
            /* start */    ["HW_Night"],
            /* alarm */    ["HW_Night"],
            /* all done */ ["HW_Night"],
        ],
        SEWERENT = [
            /* start */    ["m15down2"],
            /* alarm */    ["m15down2"],
            /* all done */ ["m15down2"],
        ],
        SEWER = [
            /* start */    ["m15down", "m02basement2"],
            /* alarm */    ["m15down", "m02basement2"],
            /* all done */ ["m15down", "m02basement2"],
        ],
        WATER = [
            /* start */    ["m09bub1"],
            /* alarm */    ["m09bub1"],
            /* all done */ ["m09bub1"],
        ],
        MANOR = [
            /* start */    ["m10inside", "m05fb"],
            /* alarm */    ["m10inside", "m05fb"],
            /* all done */ ["m10inside", "m05fb"],
        ],
        COURTYARD = [
            /* start */    ["HW_Sine6"],
            /* alarm */    ["HW_Sine6"],
            /* all done */ ["HW_Sine6"],
        ],
        BANK = [
            /* start */    ["HW_Sine6", "m00_StriSust2"],
            /* alarm */    ["HW_Sine6", "d15sub3"],
            /* all done */ ["HW_Sine6", "m00_StriSust2"],
        ],
        BANKALARM = [
            /* start */    ["HW_Sine6", "d15sub3"],
            /* alarm */    ["HW_Sine6", "d15sub3"],
            /* all done */ ["HW_Sine6", "d15sub3"],
        ],
        BASEMENT = [
            /* start */    ["m06space", "m06vikgig"],
            /* alarm */    ["HW_Sine6", "d15sub3", "m06vikgig"],
            /* all done */ ["m06space", "m06vikgig"],
        ],
        BASEALARM = [
            /* start */    ["HW_Sine6"],
            /* alarm */    ["HW_Sine6", "d15sub3"],
            /* all done */ ["HW_Sine6"],
        ],
        BSMNT = [
            /* start */    ["HW_OddityLoop"],
            /* alarm */    ["HW_OddityLoop"],
            /* all done */ ["HW_Sine6"],
        ],
        STAIRS = [
            /* start */    ["m00_SunkenPiano"],
            /* alarm */    ["m00_SunkenPiano"],
            /* all done */ ["m00_SunkenPiano"],
        ],
        STAIRS2 = [
            /* start */    ["HW_Winner"],
            /* alarm */    ["HW_Winner"],
            /* all done */ ["HW_Winner"],
        ],
        TEMPLE = [
            /* start */    ["m00_CellBlockX", "m06warble", "m00_creepywind"],
            /* alarm */    ["m00_CellBlockX", "m06warble", "m00_creepywind"],
            /* all done */ ["m00_CellBlockX", "m06warble", "m00_creepywind"],
        ],
    }

    function CurrentRegion() {
        local region = GetData("CurrentRegion");
        if (region) {
            return region;
        } else {
            return "";
        }
    }

    function CurrentProgress() {
        local progress = GetData("CurrentProgress");
        if (progress) {
            return progress;
        } else {
            return 0;
        }
    }

    function CurrentSamples() {
        local sample0 = GetData("Sample0");
        if (! sample0) { sample0 = ""; }
        local sample1 = GetData("Sample1");
        if (! sample1) { sample1 = ""; }
        local sample2 = GetData("Sample2");
        if (! sample2) { sample2 = ""; }
        return {
            [sample0] = true,
            [sample1] = true,
            [sample2] = true,
        };
    }

    function OnRegionChange() {
        local region = message().data.toupper();
        Fillip(region, CurrentProgress());
    }

    function OnDebugNextProgress() {
        local progress = CurrentProgress();
        progress = (progress + 1) % (eAmbienceProgress.kCount);
        //DarkUI.TextMessage("Ambience progress is now " + progress);
        Fillip(CurrentRegion(), progress);
    }

    function OnProgressChange() {
        local progress = message().data;
        if (progress < eAmbienceProgress.kMissionStart) {
            progress = eAmbienceProgress.kMissionStart;
        }
        if (progress > eAmbienceProgress.kAllDoneNow) {
            progress = eAmbienceProgress.kAllDoneNow;
        }
        // Always forward, never left or right--let alone back!
        if (progress > CurrentProgress()) {
            Fillip(CurrentRegion(), progress);
        }
    }

    function Fillip(region, progress) {
        local current_region = CurrentRegion();
        local current_progress = CurrentProgress();
        print("AMBIENCE FILLIP: " + current_region + " -> " + region + ", "
            + current_progress + " -> " + progress);
        if ((region != current_region)
            || (progress != current_progress))
        {
            SetData("CurrentRegion", region);
            SetData("CurrentProgress", progress);
            local samples;
            if (region in REGIONS) {
                local region_table = REGIONS[region];
                if ((progress >= 0)
                    && (progress < region_table.len()))
                {
                    local samples = region_table[progress];
                    FillipSamples(samples);
                } else {
                    print("AMBIENCE: " + region + " has no entry for progress " + progress);
                }
            } else {
                print("AMBIENCE: Unrecognised region " + region);
            }
        }
    }

    function FillipSamples(samples) {
        local current_samples = CurrentSamples();
        local start_samples = {};
        local stop_samples = {};
        // Build the new samples table
        local new_samples = {};
        foreach (_, s in samples) {
            if (s != "") {
                new_samples[s] <- true;
            }
        }
        // Compare new samples and current samples
        foreach (s, _ in new_samples) {
            if ((s != "")
                && (! (s in current_samples)))
            {
                start_samples[s] <- true;
            }
        }
        foreach (s, _ in current_samples) {
            if ((s != "")
                && (! (s in new_samples)))
            {
                stop_samples[s] <- true;
            }
        }
        // Save the new samples
        for (local i = 0; i < 3; ++i) {
            if (i < samples.len()) {
                SetData("Sample" + i, samples[i]);
            } else {
                SetData("Sample" + i, "");
            }
        }
        // Finally, stop samples that need stopping
        foreach (s, _ in stop_samples) {
            local result = Sound.HaltSchema(self, s);
        }
        // And start those that need starting
        foreach (s, _ in start_samples) {
            local result = Sound.PlaySchemaAmbient(self, s);
        }
    }
}

class PlayerAmbienceWatcher extends SqRootScript
{
    /* Put this script on the StartingPoint, together with a 
       ScriptParams("AmbienceControl") link to the AmbienceController */
    function OnObjRoomTransit() {
        if (message().ObjType != eObjType.kPlayer) return;

        local controller = Object.Named("AmbienceController");
        if (! controller) return;

        local room = message().ToObjId;
        local region = "";
        if ((room != 0) 
            && (Property.Possessed(room, "Ambient")))
        {
            region = Property.Get(room, "Ambient", "Schema Name");
        }

        PostMessage(controller, "RegionChange", region);
    }
}


class DebugNextAmbience extends SqRootScript
{
    /* For a debug inv object that allows the player to change the progress. */
    function OnTurnOn() {
        local controller = Object.Named("AmbienceController");
        if (! controller) return;
        SendMessage(controller, "DebugNextProgress");
    }
}