// THE ENTERPRISE THIEF 2 VERSION CUSTOM AUDIO SCHEMAS

// Edited 8/11/2004 - reduced pan range of rain from 3000 to 1000.

//
// Compiled, stolen, recorded, or otherwise acquired by frobber
// Heavy-duty metal grinding and cruching courtesy of the Boston MBTA 
// commuter rail system -- trains are a gift from the audio gods!
//
// Archetype here is ENT_SND

// The following new audio files use existing schemas -- documented here for reference.
// -----------------------------------------------------------------------------------
// b_elev.wav
// d_bars1c.wav
// d_bars1o.wav
// d_met1c.wav
// d_met1o.wav
// d_wood1c.wav
// d_wood1o.wav
// Elev1lp.wav
// Elev1st.wav
// Elev2lp.wav
// Elev2st.wav
// Lvcauld1.wav
// Lvcauld2.wav
// Lvwall.wav

////////////////////////////////////////
//////// Music of Lothlorien ///////////
////////////////////////////////////////

// Cat_Dubh.wav (VO played once at beginning) 
schema ent_loth1
archetype ENT_SND
volume -300
Cat_Dubh

// Black_Cat.wav (VO played once at end) 
schema ent_loth2
archetype ENT_SND
delay 3000
volume -600
Black_Cat

// Stor_Mo_Chroi.wav (possible ambient at some turning point) 
schema ent_loth3
archetype ENT_SND
mono_loop 0 0
volume -800
Stor_Mo_Chroi


////////////////////////////////////////
//////////// O.S. SPEACH ///////////////
////////////////////////////////////////

// "Help -- there's been a murder!"
schema ent_murder
archetype ENT_SND
volume 0
delay 2000
ent_murder

// Old man Solustice makes his pitch
schema ent_solust
archetype ENT_SND
volume 0
delay 2000
ent_solust

// The Oracle speaks
schema ent_oracle
archetype ENT_SND
volume 0
delay 3000
statuema


////////////////////////////////////////
//////////////// AMBIENTS //////////////
////////////////////////////////////////

// OCEAN //

// CONSTANT LOOP - OCEAN WAVES IN THE DISTANCE - louder than in Hallucinations
schema ent_ocean_dist
archetype ENT_SND
mono_loop 0 0
volume 0
ocean1

// INTERMITTEN LOOP OCEANS WAVES CLOSER - louder than in Hallucinations
schema ent_ocean_near
archetype ENT_SND
poly_loop 2 8000 20000
volume 0
no_repeat
ocean2a ocean2b

// AIR DUCTS //

// Air duct sound from South Station in Boston
schema ssairduct
archetype ENT_SND
mono_loop 0 0
// pan_range 3000
volume -800
ssairduct

// Fan noise processed from the 6:05PM Worcester Express
schema trainfan
archetype ENT_SND
mono_loop 0 0
// pan_range 3000
volume -800
trainfan


/////////////////////////////////////////////////
//////////////////// SOUNDS /////////////////////
//////// USING SWITCHABLE-AMBIENT TRAPS /////////
/////////////////////////////////////////////////


// One-time stronger distant thunder
schema thunder_once
archetype ENT_SND
volume 0
delay 4000
thundist3

// REGULAR ELEVATOR ENGAGE
schema elevstart
archetype ENT_SND
volume -200
delay 0
elevstart

// OLD ELEVATOR ENGAGE
schema elevstart_old
archetype ENT_SND
volume 0
delay 0
elevstart_old

// OLD ELEVATOR RUNNING LOOP
schema elevlp_old
archetype ENT_SND
mono_loop 0 0
volume -100
elevlp_old

// OLD ELEVATOR STOP SOUND                                         
schema elevst_old
archetype ENT_SND
volume -100
delay 0
elevst_old                                          

// Floor Creak 1 - Start
schema creakstart1
archetype ENT_SND
volume 0
delay 0
creakstart1

// Floor Creak 1 - End
schema creakend1
archetype ENT_SND
volume 0
delay 0
creakend1

// Floor Creak 2 - Start
schema creakstart2
archetype ENT_SND
volume 0
delay 0
creakstart2

// Floor Creak 2 - End
schema creakend2
archetype ENT_SND
volume 0
delay 0
creakend2


/////////////////////////////////////////////////
////// GARRETT DIALOG by Scott Murchison ////////
/////////////////////////////////////////////////


// GARRETT - "How many guards do they have in here anyway?"
schema ent_gar1
archetype ENT_SND
volume -350
delay 5000
ent_gar1

// GARRETT - "Ooohh... This is not good!"
schema ent_gar2
archetype ENT_SND
volume -300
ent_gar2

// GARRETT - "Ah... a back door"
schema ent_gar3
archetype ENT_SND
volume -400
delay 1000
ent_gar3

// GARRETT - "Faustice... you are one sick bastard..."
schema ent_gar4
archetype ENT_SND
volume -350
delay 6500
ent_gar4

// GARRETT - "WHAT do have we here!"
schema ent_gar5
archetype ENT_SND
volume -200
delay 2000
ent_gar5

// GARRETT - "Anybody home?" 
schema ent_gar6
archetype ENT_SND
volume -300
delay 2000
ent_gar6

// GARRETT - "I wonder what -this- guy was guarding"
schema ent_gar7
archetype ENT_SND
volume -350
delay 0
ent_gar7

// GARRETT - "I've had enough of this"
schema ent_gar8
archetype ENT_SND
volume -250
delay 2000
ent_gar8

// GARRETT - "Let's not try that again"
schema ent_gar9
archetype ENT_SND
volume -350
delay 500
ent_gar9

// GARRETT - "You've got to be kidding me!"
schema ent_gar10
archetype ENT_SND
volume -250
delay 2000
ent_gar10

// GARRETT - "Now that's what I call a stormy romance!"
schema ent_gar11
archetype ENT_SND
volume -350
delay 2000
ent_gar11

// GARRETT - "This guy wasn't attacked, so I wonder..."
schema ent_gar12
archetype ENT_SND
volume -250
delay 2000
ent_gar12

// GARRETT - "Hmmm... Maybe I should apply..."
schema ent_gar13
archetype ENT_SND
volume -300
delay 2000
ent_gar13