// ORACLE OF THE PROPHETS CUSTOM AUDIO SCHEMAS
//
// Compiled, stolen, recorded, or otherwise acquired or mangled by frobber.
// Archetype here is ORA_SND under the SOUND > FROBBER schema hierarchy.


// Arrival CamVator Sequence Audio (Stereo VO)
schema ora_arrive
archetype ORA_SND
volume -500
ora_arrive

////////////////////////////////////
//////// ASTEROID OUTDOORS /////////
////////////////////////////////////

// Asteroid "outdoor" basic sound.
// "Environmental" ambients -- Stereo wavs.
// Wav file are about 74 seconds -- but I don't
// want this to go entirely silent before loading
// the next sound in the poly_loop.
schema ora_astro
archetype ORA_SND
poly_loop 2 0 0
no_repeat
volume -2400
ora_astro1 ora_astro2 ora_astro3

/////////////////////////////////////
////////// OTHER AMBIENTS ///////////
/////////////////////////////////////

// Gravshaft loops
schema ora_gravshaft
archetype ORA_SND
mono_loop 0 0
no_repeat
volume -800
gravsh1 gravsh2

// Outer Caverns -- These should be stereo recordings.
schema ora_cavern
archetype ORA_SND
mono_loop 0 0
no_repeat
volume -1 // basic nature of sound is not loud
ora_room2 ora_room5 //dropped rooms 1, 3, and 4

// Room-sized ambient Lava Loops -- selected randomly
schema ora_lavalp
archetype ORA_SND
mono_loop 0 0
no_repeat
volume -1400
lavalp1 lavalp2 lavalp3

// Really loud Lava Loops -- selected randomly
schema ora_lavalp_L
archetype ORA_SND
mono_loop 0 0
no_repeat
volume -700
lavalp1 lavalp2 lavalp3

// Local Lava Bubbling -- selected randomly
schema ora_bubble
archetype ORA_SND
poly_loop 2 3000 10000
no_repeat
volume -600
bubble1 bubble2 bubble3 bubble4 burble1 burble2 burble3

// Lava Burple Loop -- to be used inside small lava cones
schema ora_bubblelp
archetype ORA_SND
mono_loop 0 0
volume -1200
bubblelp1 bubblelp2 bubblelp3

// Lava Rumbles -- occasional events
schema ora_lavarumb
archetype ORA_SND
poly_loop 2 30000 180000
delay 20000
no_repeat
volume -400
rumble1 rumble2 rumble3

// Not Ready
// tag SwitchType ButNotRead exists, so this is for anything other than a switch
schema ora_notready
archetype ORA_SND
no_repeat
volume -200
delay 200
ffall1 ffall2 ffall3 ffall4

// OS Last Cavern Button Powered Up -- Crystal areas accessable "Success"
// Probably a mission goal: "unlock access to the crystal areas"
schema ora_powerup1
archetype ORA_SND
volume -400
delay 1500
powerup1

// Force field ambient loops from Thief 2
// PURPLE CRYSTALS	<--on "MawCrystals" obj
schema ora_purple_lp
archetype ORA_SND
no_repeat
mono_loop 0 0
volume -800 //was -1600 in Thief 2
vikglow1 vikglow2 vikglow3 vikglow4 vikglow5

// Master force fields ready to be removed -- "Success"
// Probably a mission goal: "gain access to the master crystal"
schema ora_powerup2
archetype ORA_SND
volume -1
delay 500
powerup2

// Partical Bridge Starts to Deploy 
// Defined as forcefield for movement sounds
schema ora_bridge
archetype ORA_SND
volume -1
delay 0
ora_bridge

// Voices ambient loop -- heard near end-game cone in stereo
schema ora_voices
archetype ORA_SND
mono_loop 0 0
volume -1
ora_voices

// Departure Flyout Sequence Audio (Stereo VO)
schema ora_depart
archetype ORA_SND
volume -1
delay 200
ora_depart

// Various and suntry local weirdo sound loops
schema ora_wloop
archetype ORA_SND
mono_loop 0 0
no_repeat
volume -800
ora_wloop1 ora_wloop2 ora_wloop3 ora_wloop4 ora_wloop5
                                                       
// Various and sundry local beeps looped randomly
// Works okay technically -- maybe not aesthetically
schema ora_beeps
archetype ORA_SND
poly_loop 2 500 1000
no_repeat
volume -800
beep1 beep2 beep3 beep4 beep5 beep6 beep7

// Oracle Room Ambient -- This should be in stereo
schema ora_room
archetype ORA_SND
mono_loop 0 0
volume -1
ora_room


///////////////////////////////////////////////////
//////////// DOORS - PLAYER VERSION ///////////////
///////////////////////////////////////////////////


// This sound works when door object is frobbed, but NOT when CD switched or by AI "frob"

//PARTICLE DOOR -PLYR OPENING
schema prtdoor_up_p
archetype PLYR_DOOR
mono_loop 0 0
volume -600
partdoortrv
env_tag (Event StateChange) (DoorType ForceDoor)  (OpenState Opening) (OldOpenState Closed Opening Closing) (CreatureType Player)

//PARTICLE DOOR -PLYR CLOSING
schema prtdoor_down_p
archetype PLYR_DOOR
mono_loop 0 0
volume -600
partdoortrv
env_tag (Event StateChange) (DoorType ForceDoor)  (OpenState Closing) (OldOpenState Open Opening Closing) (CreatureType Player)

//PARTICLE DOOR -PLYR FULLY-OPEN SLAM
schema prtdoor_open_p
archetype PLYR_DOOR
volume -600
partdoorbeg
env_tag (Event StateChange) (DoorType ForceDoor) (OpenState Open) (OldOpenState Opening) (CreatureType Player)

//PARTICLE DOOR -PLYR FULLY-CLOSED SLAM
schema prtdoor_closed_p
archetype PLYR_DOOR
volume -200
no_repeat
partdoorend forcefieldend
env_tag (Event StateChange) (DoorType ForceDoor) (OpenState Closed) (OldOpenState Closing) (CreatureType Player)


// This sound works when door object is frobbed, but NOT when CD switched or by AI "frob"

//FORCE FIELD AREA -PLYR OPENING
schema frcfield_up_p
archetype PLYR_DOOR
mono_loop 0 0
volume -500
forcefieldtrv
env_tag (Event StateChange) (DoorType ForceField)  (OpenState Opening) (OldOpenState Closed Opening Closing) (CreatureType Player)

//FORCE FIELD AREA -PLYR CLOSING
schema frcfield_down_p
archetype PLYR_DOOR
mono_loop 0 0
volume -500
forcefieldtrv
env_tag (Event StateChange) (DoorType ForceField)  (OpenState Closing) (OldOpenState Open Opening Closing) (CreatureType Player)

//FORCE FIELD AREA -PLYR FULLY-OPEN SLAM
schema frcfield_open_p
archetype PLYR_DOOR
volume -300
forcefieldbeg
env_tag (Event StateChange) (DoorType ForceField) (OpenState Open) (OldOpenState Opening) (CreatureType Player)

//FORCE FIELD AREA -PLYR FULLY-CLOSED SLAM
schema frcfield_end_p
archetype PLYR_DOOR
volume -100
no_repeat
forcefieldend partdoorend
env_tag (Event StateChange) (DoorType ForceField) (OpenState Closed) (OldOpenState Closing) (CreatureType Player)


///////////////////////////////////////////////////////
//////////// DOORS - NON-PLAYER VERSION ///////////////
///////////////////////////////////////////////////////


// This sound works when CD switched or by AI "frob"

//PARTICLE DOOR -PLYR OPENING
schema prtdoor_up_ai
archetype AI_DOOR
mono_loop 0 0
volume -400
partdoortrv
env_tag (Event StateChange) (DoorType ForceDoor)  (OpenState Opening) (OldOpenState Closed Opening Closing)

//PARTICLE DOOR -PLYR CLOSING
schema prtdoor_down_ai
archetype AI_DOOR
mono_loop 0 0
volume -400
partdoortrv
env_tag (Event StateChange) (DoorType ForceDoor)  (OpenState Closing) (OldOpenState Open Opening Closing)

//PARTICLE DOOR -PLYR FULLY-OPEN SLAM
schema prtdoor_open_ai
archetype AI_DOOR
volume -400
partdoorbeg
env_tag (Event StateChange) (DoorType ForceDoor) (OpenState Open) (OldOpenState Opening)

//PARTICLE DOOR -PLYR FULLY-CLOSED SLAM
schema prtdoor_closed_ai
archetype AI_DOOR
volume -100
no_repeat
partdoorend forcefieldend
env_tag (Event StateChange) (DoorType ForceDoor) (OpenState Closed) (OldOpenState Closing)


// This sound works when CD switched or by AI "frob"

//FORCE FIELD AREA -PLYR OPENING
schema frcfield_up_ai
archetype AI_DOOR
mono_loop 0 0
volume -300
forcefieldtrv
env_tag (Event StateChange) (DoorType ForceField)  (OpenState Opening) (OldOpenState Closed Opening Closing)

//FORCE FIELD AREA -PLYR CLOSING
schema frcfield_down_ai
archetype AI_DOOR
mono_loop 0 0
volume -300
forcefieldtrv
env_tag (Event StateChange) (DoorType ForceField)  (OpenState Closing) (OldOpenState Open Opening Closing)

//FORCE FIELD AREA -PLYR FULLY-OPEN SLAM
schema frcfield_open_ai
archetype AI_DOOR
volume -200
forcefieldbeg
env_tag (Event StateChange) (DoorType ForceField) (OpenState Open) (OldOpenState Opening)

//FORCE FIELD AREA -PLYR FULLY-CLOSED SLAM
schema frcfield_end_ai
archetype AI_DOOR
volume -1
no_repeat
forcefieldend partdoorend
env_tag (Event StateChange) (DoorType ForceField) (OpenState Closed) (OldOpenState Closing)


//////////////////////////////////////////////
//////////// SWITCH AND BUTTONS //////////////
//////////////////////////////////////////////


// Switch doesn't work yet -- may not use this anyhow

//Particle Door Switch ON // "(DirectionState Reverse)" is correctly backwards
//schema OraSwitch_A
//archetype DEVICE_SWITCH
//volume -200
//delay 0
//ora_but1 ora_but2 ora_but3 ora_but4 ora_but5 ora_but6 ora_but7
//env_tag (Event StateChange) (SwitchType OraSwitch) (DirectionState Reverse)

//Particle Door Switch OFF // "(DirectionState Forward)" is correctly backwards
//schema OraSwitch_B
//archetype DEVICE_SWITCH
//volume -400
//delay 0
//ora_but1 ora_but2 ora_but3 ora_but4 ora_but5 ora_but6 ora_but7
//env_tag (Event StateChange) (SwitchType OraSwitch) (DirectionState Forward)

//Standard Small Oracle Buttons Frobbed
schema OraButton
archetype DEVICE_SWITCH
volume -200
delay 0
no_repeat
ora_but1 ora_but2 ora_but3 ora_but4 ora_but5 ora_but6 ora_but7
env_tag (Event Activate) (SwitchType OraButton)

//Cavern Main Buttons Frobbed
schema OraBigButn
archetype DEVICE_SWITCH
volume -100
delay 0
no_repeat
psiactiv psiactix psiactiz
env_tag (Event Activate) (SwitchType OraBigButn)

//Button Frobbed makes "Not Ready" Sound
schema ButNotRead
archetype DEVICE_SWITCH
volume -200
delay 0
no_repeat
ffall1 ffall2 ffall3 ffall4
env_tag (Event Activate) (SwitchType ButNotRead)

//Crystals Frobbed
schema OraCrystal
archetype DEVICE_SWITCH
volume -1000
delay 0
no_repeat
psiregen psihypno psihacac psiadvre psion
env_tag (Event Activate) (SwitchType OraCrystal)



///////////////////////////////////////
/////// CONVERSATION MONOLOGS /////////
///////////////////////////////////////

// Garrett speaks with Crazed Mechanist
// Both voices by Scott Murchison a.k.a., SlyFoxx
schema ora_mechanist
archetype ORA_SND
volume -1
delay 4000
ora_garmech // Crazy Mech part NOT YET RECORDED

// Karras speaks to Precursors via Victrola
// drivel by frobber - so don't blame anyone else!
schema ora_karras
archetype ORA_SND
volume -1
delay 250
ora_karras

// The Oracle speaks to Garrett near volcano - "Do not let fear..."
// Stolen from Thief 1 
schema ora_oracle1
archetype ORA_SND
volume -1
delay 5000
ora_oracle1

// Garrett speaks with Oracle in final scene - Part One
// Both voices by Scott Murchison a.k.a., SlyFoxx
// Split into three sound files to improve subtitle synchronization.
schema ora_oracle2a
archetype ORA_SND
volume -1
delay 4000
ora_oracle2a

// Garrett speaks with Oracle in final scene - Part Two
// Both voices by Scott Murchison a.k.a., SlyFoxx
// Split into three sound files to improve subtitle synchronization.
schema ora_oracle2b
archetype ORA_SND
volume -1
ora_oracle2b

// Garrett speaks with Oracle in final scene - Part Three
// Both voices by Scott Murchison a.k.a., SlyFoxx
// Split into three sound files to improve subtitle synchronization.
schema ora_oracle2c
archetype ORA_SND
volume -1
ora_oracle2c

// Garrett speaks with Oracle in final scene - Part Three
// Original full-lenth file here for legacy testing only
schema ora_oracle2
archetype ORA_SND
volume -1
delay 4000
ora_oracle2


/////////////////////////////////////////////////
////// GARRETT DIALOG by Scott Murchison ////////
/////////////////////////////////////////////////


// GARRETT - "I liked it better when these hallucinations didn't hurt"
// May not use this one -- originally intended for falling at mission start.
schema ora_gar1
archetype ORA_SND
volume -300
delay 0
ora_gar1

// GARRETT - "This Hallucination is getting more annoying by the minute"
// Added to the main conversation wav. Use only if main conv is cancelled.
schema ora_gar2
archetype ORA_SND
volume -250
delay 1000
ora_gar2

// GARRETT - "Looks like nothing very intersting on the surface"
// NOT USED -- going "down below" isn't obvious from anywhere above.
// schema ora_gar3
// archetype ORA_SND
// volume -300
// delay 1000

// GARRETT - "So long as I keep finding bodies, I suppose..."
// Perhaps when he finds Kelvin
schema ora_gar3
archetype ORA_SND
volume -250
delay 2000
ora_gar3