//Script by nicked
//This is a squirrel script I just made which will check the door closed/open status and locked/unlocked status. If the door is both closed AND locked, it sends a TurnOn down a ScriptParams link with data ClosedLocked

class ClosedLocked extends SqRootScript
{
	function OnBeginScript()
	{
		if(! IsDataSet("Initialised")) 
		{
			SetData("Initialised", 1);
			
			local doorstate = 0;
			local lockstate = 0;
		
			local startdoorstate = (Door.GetDoorState(self));
			local startlockstate = (Locked.IsLocked(self));
		
			if(startdoorstate==eDoorStatus.kDoorClosed)
			{
				doorstate = 1;
			}
			else
			{
				doorstate = 0;
			}
			
			SetData("DoorState", doorstate);
			
			if(startlockstate)
			{
				lockstate = 1;
			}
			else
			{
				lockstate = 0;
			}
		
			SetData("LockState", lockstate);
			CheckDoorState();
		}
	}

	function OnDoorClose()
	{
		local doorstate = GetData("DoorState");
		doorstate = 1;		
		SetData("DoorState", doorstate);
		//Door is closed.
		CheckDoorState();
	}
	
	function OnDoorOpening()
	{
		local doorstate = GetData("DoorState");
		doorstate = 0;
		SetData("DoorState", doorstate);
		//Door is open or opening.
		CheckDoorState();
	}	
	
	function OnNowLocked()

	{
		local lockstate = GetData("LockState");
		lockstate = 1;
		SetData("LockState", lockstate);
		//Door is locked.
		CheckDoorState();
	}
	
	function OnNowUnlocked()

	{
		local lockstate = GetData("LockState");
		lockstate = 0;
		SetData("LockState", lockstate);
		//Door is unlocked.
		CheckDoorState();
	}
	
	function CheckDoorState()
	{
		//Checking door state.
		local doorstate = GetData("DoorState");
	
		//Checking lock state.
		local lockstate = GetData("LockState");
		
		if(doorstate == 1 && lockstate == 1)
		{
			//Door conditions met. Sending TurnOn to anything linked via ScriptParams (Data "ClosedLocked")
			Link.BroadcastOnAllLinksData(self,"TurnOn","ScriptParams","ClosedLocked");
		}
		
		if(doorstate != 1 || lockstate != 1)
		{
			//Door conditions no longer met. Sending TurnOff to anything linked via ScriptParams (Data "ClosedLocked")
			Link.BroadcastOnAllLinksData(self,"TurnOff","ScriptParams","ClosedLocked");
		}
		
	}
}