class TeleportingAi extends SqRootScript {
	function OnSim() {
		if (message().starting) {
			print("Registering AI: " + self + " to manager: " + ObjID("AiTeleportManager"));
			local linkId = Link.Create("ScriptParams", ObjID("AiTeleportManager"), self);
			LinkTools.LinkSetData(linkId, "", "teleport");
			SetData("managerLinkId", linkId);
		}
	}
}


class TeleportingAiManager extends SqRootScript {
	function OnTurnOn() {
		local playerId = Networking.FirstPlayer();
		local targetLocationObj = ObjID(userparams().TeleportTarget);
		local targetPosition = Object.Position(targetLocationObj);
		local targetFacing = Object.Facing(targetLocationObj);

		print("Attempting to teleport everybody to: " + targetPosition);
		foreach(link in Link.GetAll("ScriptParams", self)) {
			local linkDest = LinkDest(link);
			local linkData = LinkTools.LinkGetData(link, "");
			if (linkData != "teleport") {
				print("Unknown linkdata. Skipping teleport: " + linkDest);
				continue;
			}

			if (Object.HasMetaProperty(linkDest, ObjID("M-KnockedOut"))) {
				print("AI is unconscious. Skipping teleport: " + linkDest);
				continue;
			}

			if (Property.Possessed(linkDest, "HitPoints") &&
				Property.Get(linkDest, "HitPoints", "") <= 0
			) {
				print("AI is dead. Skipping teleport: " + linkDest);
				continue;
			}

			local awarenessLink = Link.GetOne(linkkind("AIAwareness"), linkDest, playerId);
			local investLink = Link.GetOne(linkkind("AIInvest"), linkDest, playerId);
			local attackLink = Link.GetOne(linkkind("AIAttack"), linkDest, playerId);
			local fleeLink = Link.GetOne(linkkind("AIFleeSource"), linkDest, playerId);
			if (investLink || attackLink || fleeLink || (awarenessLink && LinkTools.LinkGetData(awarenessLink, "Level") >= 2)) {
				print("AI is investigating/attacking/fleeing player. Skipping teleport: " + linkDest);
				continue;
			}

			print("Teleporting: " + linkDest);
			Object.Teleport(linkDest, targetPosition, targetFacing)
		}
	}
}

/// Script by Jayrude
/// This script makes it so any live AI that isn't KO'd gets teleported to a target when the AiTeleportManager is ControlDevice'd.
/// You add the TeleportingAi script to any AI that needs teleporting, then have an object named AiTeleportManager somewhere and give it Scripts: TeleportingAiManager, and have a teleport destination object wherever you want named TeleportMe, putting its ID in the teleport manager's design notes as TeleportTarget=TeleportMe.