//=============================================================================
// The VulnerabilityObject class.
//=============================================================================
class VulnerabilityObject extends MetaProperty
	abstract
	native;
	
struct StimulusVulnerability
{
	var()			 float			Vulnerability				"The vulnerability to the stimulus (0 to 1; 0=invulnerable, 1=completly vulnerable)";
	var()			 float			MinHealthDamage				"The minimum organic damage amount that must be infliced before it is applied to the unit";
	var()			 float			StimToHealthDamageFactor	"The rate in which stim is converted to organic damage";
	var() deusexprop float			MinEnergyDrain				"The minimum mechanic damage amount that must be infliced before it is applied to the unit";	
	var() deusexprop float			StimToEnergyDrainFactor		"The rate in which stim is converted to mechanic damage";
	var()			 bool			IsFakeDamage				"If true, will not deduct actual hitpoints, but count towards knocking AI into 'playing-possum' state.";
//	var()			 eStimulusType	StimulusType				"The type of stimulus this vulnerability is used for";	
};	

var(Stimulus) inherited(959) customviewer StimulusVulnerability Vulnerabilities[eStimulusType.EnumCount] "Array of vulnerabilities for things linked to this metaobject";
	

classproperties
{
    ClassPlaceableStatus=FALSE
}


defaultproperties
{
}
