//=============================================================================
// Difficulty Info Object
// This is placed in a level with the settings for each difficulty level.
// Also keeps track of the current difficulty level setting and the current
// difficulty settings.
//=============================================================================

class DifficultyInfo extends Info
	native;
	
#exec Texture Import File=Textures\DifficultyInfo.bmp Name=S_DiffInfo Mips=Off Flags=2
	
enum eAISenseLevel
{
	kAISense_Low,
	kAISense_Normal,
	kAISense_High,
	kAISense_VeryHigh
};

enum eAICombatLevel
{
	kAICombat_Low,
	kAICombat_Normal,
	kAICombat_High,
	kAICombat_VeryHigh
};

enum eAIDensityLevel
{
	kAIDensity_Low,
	kAIDensity_Normal,
	kAIDensity_High
};

enum eDamageResistLevel
{
	kDamageResist_VeryLow,
	kDamageResist_Low,
	kDamageResist_Normal,
	kDamageResist_High,
	kDamageResist_VeryHigh
};

struct DifficultyLevel
{
	var() int					LootPercent;
	var() int					SpecialLoot;
	var() int					MinBlackjack;
	var() int					MaxBlackjack;
	var() int					MinKill;
	var() int					MaxKill;
	var() bool					DontBlackjackNonComb;
	var() bool					DontKillNonComb;
	var() int					MaxDetected;
	var() int					MaxCorpsesFound;
	var() eAISenseLevel			AISenses;
	var() eAICombatLevel		AICombat;
	var() eAIDensityLevel		AIDensity;
	var() eDamageResistLevel	PlayerDamageResistance;
	var() int					TimeLimit;
};

enum eDifficultyLevels
{
	kDifficulty_Easy,
	kDifficulty_Normal,
	kDifficulty_Hard,
	kDifficulty_Expert,
	kDifficulty_Custom,
};

var(Difficulty) Name					LevelName;
var(Difficulty) DifficultyLevel			EasyDiffSettings;
var(Difficulty) DifficultyLevel			NormalDiffSettings;
var(Difficulty) DifficultyLevel			HardDiffSettings;
var(Difficulty) DifficultyLevel			ExpertDiffSettings;

var(Difficulty) inherited (2081) Name				DifficultyInfoLevelName;
var(Difficulty) inherited (2082) DifficultyLevel	DifficultyInfoEasyDiffSettings;
var(Difficulty) inherited (2083) DifficultyLevel	DifficultyInfoNormalDiffSettings;
var(Difficulty) inherited (2084) DifficultyLevel	DifficultyInfoHardDiffSettings;
var(Difficulty) inherited (2085) DifficultyLevel	DifficultyInfoExpertDiffSettings;

var transient eDifficultyLevels			CurrentDifficulty;
var transient DifficultyLevel			CustomDiffSettings;

classproperties
{
    ClassPlaceableStatus=FALSE
}


defaultproperties
{
     Texture=Texture'T3Game.S_DiffInfo'
     bNotTickable=True
     bNotMoveableRender=True
     bNotSpawnable=True
     bNotMoveablePhysics=True
}
