//=============================================================================
// Enter Mission Info Object
// This is placed in a level with the settings for the level that a particular
// door or teleport region will transport the player to.  Thus, the player can
// decide if they actually want to take a mission before loading the level.
//=============================================================================

class EnterMissionInfo extends Info
	placeable
	native;
	
#exec Texture Import File=Textures\EnterMissionInfo.bmp Name=S_EntMissInfo Mips=Off Flags=2

struct thiefprop LoadoutItem
{
	var() string ItemName;
	var() int Num;
};

var() bool					EntryMapObjectFlag "This should only be set to TRUE if this instance is to be in the Entry map.";
var() string				VisibleObjectivesFileName "Text file with objectives displayed to the player.";
var() Array<LoadoutItem>    DefaultInventory "Items the player will have added to their inventory at startup.";
var() string				BriefingFileName "The file name of the briefing that will be displayed.";
var() string				BriefingVoiceOverSchemaName "The schema name of the voice over that plays the briefing.";
var() bool					AbortFlag "Can the user abort from the Enter Mission screen?";
var() int					HandDrawnMap0 "List the index for the first hand-drawn map for this level (i.e., enter '6' for hand drawn map #6, etc.).  If the 'meta_HasHandDrawnMap6' global variable is true, that map will appear on the map screen.  Enter -1 for no map.";
var() int					HandDrawnMap1 "List the index for the second hand-drawn map for this level (i.e., enter '6' for hand drawn map #6, etc.).  If the 'meta_HasHandDrawnMap6' global variable is true, that map will appear on the map screen.  Enter -1 for no map.";
var() int					HandDrawnMap2 "List the index for the third hand-drawn map for this level  (i.e., enter '6' for hand drawn map #6, etc.).  If the 'meta_HasHandDrawnMap6' global variable is true, that map will appear on the map screen.  Enter -1 for no map.";
var() int					HandDrawnMap3 "List the index for the fourth hand-drawn map for this level (i.e., enter '6' for hand drawn map #6, etc.).  If the 'meta_HasHandDrawnMap6' global variable is true, that map will appear on the map screen.  Enter -1 for no map.";
var() int					HandDrawnMap4 "List the index for the fifth hand-drawn map for this level (i.e., enter '6' for hand drawn map #6, etc.).  If the 'meta_HasHandDrawnMap6' global variable is true, that map will appear on the map screen.  Enter -1 for no map.";
var() string				PostStartMissionBinkFileName "The name of the Bink FMV file to play after the user hits 'StartMission' on the Enter Mission screen";

var() inherited (2063) bool					EnterMissionEntryMapObjectFlag "This should only be set to TRUE if this instance is to be in the Entry map.";
var() inherited (2064) string				EnterMissionVisibleObjectivesFileName "Text file with objectives displayed to the player.";
var() inherited (2065) Array<LoadoutItem>   EnterMissionDefaultInventory "Items the player will have added to their inventory at startup.";
var() inherited (2066) string				EnterMissionBriefingFileName "The file name of the briefing that will be displayed.";
var() inherited (2067) string				EnterMissionBriefingVoiceOverSchemaName "The schema name of the voice over that plays the briefing.";
var() inherited (2068) bool					EnterMissionAbortFlag "Can the user abort from the Enter Mission screen?";
var() inherited (2069) int					EnterMissionHandDrawnMap0 "List the index for the first hand-drawn map for this level (i.e., enter '6' for hand drawn map #6, etc.).  If the 'meta_HasHandDrawnMap6' global variable is true, that map will appear on the map screen.  Enter -1 for no map.";
var() inherited (2070) int					EnterMissionHandDrawnMap1 "List the index for the second hand-drawn map for this level (i.e., enter '6' for hand drawn map #6, etc.).  If the 'meta_HasHandDrawnMap6' global variable is true, that map will appear on the map screen.  Enter -1 for no map.";
var() inherited (2071) int					EnterMissionHandDrawnMap2 "List the index for the third hand-drawn map for this level  (i.e., enter '6' for hand drawn map #6, etc.).  If the 'meta_HasHandDrawnMap6' global variable is true, that map will appear on the map screen.  Enter -1 for no map.";
var() inherited (2072) int					EnterMissionHandDrawnMap3 "List the index for the fourth hand-drawn map for this level (i.e., enter '6' for hand drawn map #6, etc.).  If the 'meta_HasHandDrawnMap6' global variable is true, that map will appear on the map screen.  Enter -1 for no map.";
var() inherited (2073) int					EnterMissionHandDrawnMap4 "List the index for the fifth hand-drawn map for this level (i.e., enter '6' for hand drawn map #6, etc.).  If the 'meta_HasHandDrawnMap6' global variable is true, that map will appear on the map screen.  Enter -1 for no map.";
var() inherited (2074) string				EnterMissionPostStartMissionBinkFileName "The name of the Bink FMV file to play after the user hits 'StartMission' on the Enter Mission screen";
var() inherited (2086) int					EnterMissionHDMapAdded "The index of a hand-drawn map that is ADDED to your inventory during the Enter Mission screen, -1 for none.";
var() inherited (2147) bool					EnterMissionInventoryReplaces "If set to TRUE, the Default Inventory will *replace* current inventory.  If FALSE, will simply *add* to inventory";
var() inherited (2148) bool					EnterMissionDisableDifficultySelect "If set to TRUE, the user will not be able to set custom difficulty.";

classproperties
{
    ClassPlaceableStatus=TRUE
}


defaultproperties
{
     Texture=Texture'T3Game.S_EntMissInfo'
     bNotTickable=True
     bNotMoveableRender=True
     bNotSpawnable=True
     bNotMoveablePhysics=True
}
