//=============================================================================
// Exit Mission Info Object
// This is placed in a level with the settings for the level that a particular
// door or teleport region will transport the player to when the mission is
// complete.
//=============================================================================

class ExitMissionInfo extends Info
	placeable
	native;
	
#exec Texture Import File=Textures\ExitMissionInfo.bmp Name=S_ExtMissInfo Mips=Off Flags=2

var() bool					EntryMapObjectFlag "Set to true if this is the exit object in the Entry map ONLY";
var() string				DestMapName "The destination map";
var() string				DestTeleportName "The destination teleporter";
var() string				FirstVisitGlobalVar	"The global variable name; if this global var is false, it means it's the first time we've visited the dest map and will play a voice-over.";
var() string				PostContinueBinkFileName "The name of the Bink FMV file to play after the user hits 'Continue' on the Mission Complete screen";
var() string				DebriefingVOSchemaName "Schema name for debriefing voice over.  If the alternate debriefing flag is set, will increment this by one";

var() inherited (2075) bool		ExitMissionEntryMapObjectFlag "Set to true if this is the exit object in the Entry map ONLY";
var() inherited (2076) string	ExitMissionDestMapName "The destination map";
var() inherited (2077) string	ExitMissionDestTeleportName "The destination teleporter";
var() inherited (2078) string	ExitMissionFirstVisitGlobalVar	"The global variable name; if this global var is false, it means it's the first time we've visited the dest map and will play a voice-over.";
var() inherited (2079) string	ExitMissionPostContinueBinkFileName "The name of the Bink FMV file to play after the user hits 'Continue' on the Mission Complete screen";
var() inherited (2080) string	ExitMissionDebriefingVOSchemaName "Schema name for debriefing voice over.  If the alternate debriefing flag is set, will increment this by one";

classproperties
{
    ClassPlaceableStatus=TRUE
}


defaultproperties
{
     Texture=Texture'T3Game.S_ExtMissInfo'
     bNotTickable=True
     bNotMoveableRender=True
     bNotSpawnable=True
     bNotMoveablePhysics=True
}
