//=============================================================================
// Spell, the invisible actor class that underlies a spell projectile in Thief.
//
// Spells carry an associated Phantom with them that they use for collision
// detection. However the spell itself is not visible. It must be rigidly
// attached to an emitter.
//
// Spells must integrate their physics themselves, they cannot rely upon the
// game physics.
//=============================================================================
class SpellProjectile extends Actor
	abstract
	native
	nativereplication;
	
var native rotator localRotationRate; // caches the RotationRate inherited property.
var(Weapon) inherited(2111) bool	bBlastRadiusDoesNotAffectFriendlies "When this spell detonates, its stim will only be splash-damaged onto pawns in the blast radius if they are NOT allied with the spellcaster. However pawns directly hit will ALWAYS be stimmed.";
var int CollisionFilterInfo; // for saving/loading collision filter info
var noexport native int pad; // for the pointer to phantom.

// we use the CollisionRadius property to specify the spell's physical radius.

classproperties
{
    ClassPlaceableStatus=FALSE
}


defaultproperties
{
     bBlastRadiusDoesNotAffectFriendlies=False
}
