//=============================================================================
// WakeupCameraPoint
// Used to give the wakeup camera hints about where to begin and end its pan.
//=============================================================================
class WakeupCameraPoint extends Keypoint
	native;

#exec Texture Import File=Textures\WakeupCameraPoint.bmp Name=WakeupCameraPoint_Img Mips=Off MASKED=1

var() bool					Start "Set to true if this is the starting point for the wake up camera.";
var() float					Seconds "How fast will the camera move from the start to the end.";
var() int					UniqueId "If there are multiple wakeup point pairs in a single map, match each pair with a unique number.";

classproperties
{
    ClassPlaceableStatus=TRUE
}


defaultproperties
{
     Seconds=5.000000
     Texture=Texture'T3Game.WakeupCameraPoint_Img'
}
