class Garrett extends PlayerPawn
	native
	placeable
	nativereplication
	alwaysload;

struct thiefprop InvLootRecord
{
	var string ItemName;		//Loot piece name
	var int Quantity;
	var int SellPrice;
	var ELootType lootType;		//Gem, metal, or artwork
	var bool bSpecial;			//Is this loot, or special loot?
};

struct thiefprop InvQuestItemRecord
{
	var string ClassName;		//The class name for the quest item (necessary when removing from script)
	var string ItemName;		//Quest item name
	var int Quantity;
};

struct thiefprop RemovedInventoryInfo
{
	var Class invClass;
	var int num;
};

var Travel Array<RemovedInventoryInfo> RemovedInventory;

var float standingSpeedDef[19];
var float crouchingSpeedDef[19];

var transient Actor curTarget;
var Actor ladderToMount;
var Actor ropeToMount;
var Actor railToVault;
var Actor bodyCarrying;
var float ropeToMountYaw;
var float ropeRotateSpeed;
var vector railToVaultNormal;

var int AnimToPlay;
var int NextState;
var int MtNextState;

var vector moveToLoc;
var int moveToYaw;

var string neckBoneName;
var int neckBoneNumber;
var string rightArmBoneName;
var int rightArmBoneNumber;
var string leftArmBoneName;
var int leftArmBoneNumber;
var string cameraBoneName;
var int cameraBoneNumber;
var string headingBoneName;
var int headingBoneNumber;
var string leftFootBoneName;
var int leftFootBoneNumber;
var string rightFootBoneName;
var int rightFootBoneNumber;
var string pelvisBoneName;
var int pelvisBoneNumber;
var string leftHandBoneName;
var int leftHandBoneNumber;
var string rightHandBoneName;
var int rightHandBoneNumber;

var rotator HeadRot;
var float newPitchRot;
var float newYawRot;

var float jumpVel;

var float mantleZ;
var Actor MantleSurface;

var(FallDamage) float MinFallDamage;
var(FallDamage) float MaxFallDamage;
var(FallDamage) float FallDamageModifier;

var float MantleMinHeight;
var float MantleMaxHeight;
var float MantleMinHeightJump;

var float StandingCollisionHeight;
var float StandingCollisionRadius;

var Actor WeaponHolding;
var Actor ArrowHolding;
var Actor WeaponToHold;
var int WeaponStanceTypeHolding;

var bool bInBowDraw;
var bool isCrouching;  //pawn already has something like this, but physics code does stuff i dont want it to if it is set
var bool CanDoItemSearch;
var bool CanUseItems;
var bool bUpdatePhysHeight;
var bool bCrouchAfterMantle;
var OptionTravel bool bIsCameraInFirstPersonForTravel;	// used only for travelling - this makes sure the default camera mode persists

var float LastTickTime;

var actor ObjectToLockPick;  //will point to the object that garrett is lockpicking
var actor LockHandleToMove; //points to the handle that should rotate while picking

var pawn AIToAttack;

var int CameraMode;
var rotator CameraRotation;

var Travel int playerGold;

var Travel Array<InvLootRecord> playerLootList;	//The list of player loot (textual, since we can't load all loot all the time)
var Travel Array<InvQuestItemRecord> playerQuestItemsList;	//Similar to above, but for quest items and keys

var Travel bool bIn3rdPersonMode;		// true when in 3rd person mode, false when in 1st person mode
var bool bLeftFootDown;			// true when the left foot is on the ground

var float fidgetDelayTime;		// secs that must elapse before first fidget is played
var float fidgetCycleTime;		// secs between subsequent fidgets
var float fidgetCycleRandom;	// max for random amount of secs added to fidgetCycleTime

var float backwardsTranslationScale; // scaler to apply to backward movement speed

var Actor ObjectToThrow;		// object to throw
var float throwVel;				// drop/throw velocity
var float MinThrowForce;		
var float MaxThrowForce;

var float maxFrobAngleCos;		// defines the frobbing cone - cos of the max angle for frobbing in 1st person
var float maxFrobAngleCos_3P;	// defines the frobbing cone - cos of the max angle for frobbing in 3rd person

var Actor	closestAIInRange;
var Actor	closestHostileAI;			// closest ai w/in range
var vector	distanceToClosestHostileAI;
var bool	bInPublicSpace;		// G is in a public space (not in an intrusion volume)
var bool	bIsInCitySection;	// G is in a city section

var bool	bNoiseEnabled;

var float	movementStickXValue;// normalized analog stick X value
var float	movementStickYValue;// normalized analog stick Y value

var float	physicsSpeed;// actual speed of G according to physics

var inherited(2119) bool  bFlattenedOnWall;
var(LightLevel) float wallFlattenedLightModifier "Garrett's additional light level bonus for being flattened on a wall";

var Travel Array<float> firstPersonMantleTable;			// TPERRY added these to persist the mantle table that
var Travel Array<float> thirdPersonMantleTable;			// was being calculated on every load
var Travel float		 firstPersonMaxMantleHeight;
var Travel float		 thirdPersonMaxMantleHeight;

var Travel string hammerFactionActions[3];	//Last three Hammer-related actions
var Travel string paganFactionActions[3];	//Last three Pagan-related actions

struct thiefprop LoadoutItem
{
	var() string ItemName;
	var() int Num;
};

//The following variables are used for travelling on new games *ONLY*.
//We had to do this because we wanted *some* things to travel, but not everything, because Garrett may be in a bad
//state to be travelling.  These vars set difficulty, etc., for the new game.
//START OPTIONS TRAVEL
//("gi" -> "global int", where it comes from and where it will go)
struct thiefprop NewGameOptionsRecord
{
	var int options_gi_dif_currdifficulty;
	var int options_gi_dif_LootPercent;
	var int options_gi_dif_SpecialLoot;
	var int options_gi_dif_MinBlackjack;
	var int options_gi_dif_MaxBlackjack;
	var int options_gi_dif_MinKill;
	var int options_gi_dif_MaxKill;
	var int options_gi_dif_DontBlackjackNonComb;
	var int options_gi_dif_DontKillNonComb;
	var int options_gi_dif_MaxDetected;
	var int options_gi_dif_MaxCorpsesFound;
	var int options_gi_dif_AISenses;
	var int options_gi_dif_AICombat;
	var int options_gi_dif_AIDensity;
	var int options_gi_dif_PlayerDamageResistance;
	var int options_gi_dif_TimeLimit;
	var int options_gi_meta_MissionHandDrawnMapIndex_0;
	var int options_gi_meta_MissionHandDrawnMapIndex_1;
	var int options_gi_meta_MissionHandDrawnMapIndex_2;
	var int options_gi_meta_MissionHandDrawnMapIndex_3;
	var int options_gi_meta_MissionHandDrawnMapIndex_4;
	var int options_gi_firstHandDrawnMap;
	var Array<LoadoutItem> options_initial_inventory;
};
//END OPTIONS TRAVEL

var OptionTravel inherited (2062) NewGameOptionsRecord newGameOptions "Options vars that travel for new game *ONLY*.";

var enum GARRETT_SPEEDS
{
	GSP_SLOW,
	GSP_MEDIUM,
	GSP_FAST,
	GSP_IDLE
} InputSpeed;

var enum EArmUse
{
	EAU_FREE,
	EAU_FORCED_BODY,
	EAU_FORCED_ARMS
}ArmUse;

var enum EBodyMovementType
{
	ERT_Normal,
	ERT_RotateBodyOnly,
	ERT_NoMovement
}BodyMovementType;

var enum EFaction
{
	EF_Hammer,
	EF_Pagan
}Faction;

var enum EFatalAttackState
{
	eFAS_None,
	eFAS_ArmsPrepared,
	eFAS_BodyPrepared,
	eFAS_Attacking
}FatalAttackState;

var struct AnimCall
{	
	var name name;
	var bool tween;
	var bool finish;
	var FLOAT startPos;	
} GAnimCall;

classproperties
{
    ClassPlaceableStatus=TRUE
}


defaultproperties
{
     standingSpeedDef(0)=0.050000
     standingSpeedDef(1)=0.150000
     standingSpeedDef(2)=0.950000
     standingSpeedDef(3)=40.000000
     standingSpeedDef(4)=80.000000
     standingSpeedDef(5)=180.000000
     standingSpeedDef(7)=0.500000
     standingSpeedDef(8)=0.667000
     standingSpeedDef(9)=1.000000
     standingSpeedDef(10)=1.250000
     standingSpeedDef(11)=1.000000
     standingSpeedDef(12)=1.000000
     standingSpeedDef(13)=70.000000
     standingSpeedDef(14)=90.000000
     standingSpeedDef(15)=170.000000
     standingSpeedDef(16)=0.050000
     standingSpeedDef(17)=0.500000
     standingSpeedDef(18)=0.950000
     crouchingSpeedDef(0)=0.050000
     crouchingSpeedDef(1)=0.400000
     crouchingSpeedDef(2)=0.950000
     crouchingSpeedDef(3)=21.000000
     crouchingSpeedDef(4)=30.000000
     crouchingSpeedDef(5)=60.000000
     crouchingSpeedDef(7)=0.700000
     crouchingSpeedDef(8)=0.625000
     crouchingSpeedDef(9)=1.000000
     crouchingSpeedDef(10)=1.250000
     crouchingSpeedDef(11)=1.000000
     crouchingSpeedDef(12)=1.000000
     crouchingSpeedDef(13)=32.000000
     crouchingSpeedDef(14)=32.000000
     crouchingSpeedDef(15)=32.000000
     crouchingSpeedDef(16)=0.030000
     crouchingSpeedDef(17)=0.200000
     crouchingSpeedDef(18)=0.850000
     ropeRotateSpeed=10000.000000
     neckBoneName="Garrett Head"
     rightArmBoneName="Garrett R UpperArm"
     leftArmBoneName="Garrett L UpperArm"
     cameraBoneName="Camera Attach"
     headingBoneName="Header Node"
     leftFootBoneName="Garrett L Toe0"
     rightFootBoneName="Garrett R Toe0"
     pelvisBoneName="Garrett Pelvis"
     leftHandBoneName="Garrett L Finger2"
     rightHandBoneName="Garrett R Finger2"
     jumpVel=225.000000
     MinFallDamage=128.000000
     MaxFallDamage=640.000000
     FallDamageModifier=1.000000
     MantleMinHeight=48.000000
     MantleMaxHeight=104.000000
     MantleMinHeightJump=48.000000
     CanDoItemSearch=True
     CanUseItems=True
     bUpdatePhysHeight=True
     fidgetDelayTime=5.000000
     fidgetCycleTime=1.000000
     fidgetCycleRandom=4.000000
     MinThrowForce=0.250000
     MaxThrowForce=650.000000
     maxFrobAngleCos=0.900000
     maxFrobAngleCos_3P=0.700000
     bInPublicSpace=True
     wallFlattenedLightModifier=-0.100000
     BaseEyeHeight=27.000000
     EyeHeight=27.000000
     CrouchHeight=20.000000
     CrouchRadius=20.000000
     BoneToBodyLocationMap(0)=(BoneName="Garrett Head",BodyLocation=BodyLocation_Head)
     BoneToBodyLocationMap(1)=(BoneName="Garrett L Calf",BodyLocation=BodyLocation_LeftLeg)
     BoneToBodyLocationMap(2)=(BoneName="Garrett L Forearm",BodyLocation=BodyLocation_LeftArm)
     BoneToBodyLocationMap(3)=(BoneName="Garrett L Thigh",BodyLocation=BodyLocation_LeftLeg)
     BoneToBodyLocationMap(4)=(BoneName="Garrett L UpperArm",BodyLocation=BodyLocation_LeftArm)
     BoneToBodyLocationMap(5)=(BoneName="Garrett Pelvis",BodyLocation=BodyLocation_Torso)
     BoneToBodyLocationMap(6)=(BoneName="Garrett R Calf",BodyLocation=BodyLocation_RightLeg)
     BoneToBodyLocationMap(7)=(BoneName="Garrett R Forearm",BodyLocation=BodyLocation_RightArm)
     BoneToBodyLocationMap(8)=(BoneName="Garrett R Thigh",BodyLocation=BodyLocation_RightLeg)
     BoneToBodyLocationMap(9)=(BoneName="Garrett R UpperArm",BodyLocation=BodyLocation_RightArm)
     BoneToBodyLocationMap(10)=(BoneName="Garrett Spine",BodyLocation=BodyLocation_Torso)
     BoneToBodyLocationMap(11)=(BoneName="Garrett Spine1",BodyLocation=BodyLocation_Torso)
     Physics=PHYS_Havok
     InitialHavokState=Havok_Walking
     SkeletalTag="Garrett_08"
     CollisionRadius=21.000000
     CollisionHeight=44.000000
     bAlwaysDraw=True
     CharacterType="player"
     HealthState=HealthState_Alive
     JumpHeight=48.000000
     HoldArrowTime=10.000000
     WeakArrowTime=5.000000
     BowStrength=2450.000000
     MaxWeakRotation=400
     WeakRotPerSec=200
     BowDrawPerSec=1.400000
     BowFOVZoomIn=20.000000
     BowFOVZoomInSpeed=30.000000
     BowFOVZoomInDelay=2.000000
     BowFOVZoomOutSpeed=40.000000
     BowFOVZoomOutDelay=0.000000
     BowFOVImmediateZoomInSpeed=80.000000
     BowFOVImmediateZoomOutSpeed=80.000000
     BaseFOV=75.000000
     AddlLineHeight=4.000000
     MechEyeMaxZoomFOV=20.000000
     MechEyeZoomRate=60.000000
     MechExeQuickExitZoomRate=200.000000
     CollisionDamageVelModifier=1.000000
     CollisionDamageRatioMax=3.000000
     AirControlMultiplier=0.970000
}
