class AllYourBase extends SqRootScript
{
	function getOnMessage()
	{
		local onMsg = "TurnOn"; //default
		if (HasProperty("DesignNote"))
		{
			local scrNameOn = GetClassName() + "On";
			if(scrNameOn in userparams())
			{
				onMsg = userparams()[scrNameOn];
			}
		}
		return onMsg;
	}
	
	function getOffMessage()
	{
		local offMsg = "TurnOff"; //default
		if (HasProperty("DesignNote"))
		{
			local scrNameOff = GetClassName() + "Off";
			if(scrNameOff in userparams())
			{
				offMsg = userparams()[scrNameOff];
			}
		}
		return offMsg;
	}
	
	//For params that can also be 'self' if not specified.
	function getParam(paramName)
	{
		local readParam; //value in design note;
		local finalParam = self; //default value, or copy of param;
		if(HasProperty("DesignNote"))
		{
			if(paramName in userparams())
			{
				readParam = userparams()[paramName];
				if(readParam != "[me]")
				{
					finalParam = readParam;
				}
			}
		}
		return finalParam;
	}
}

class EditorOnly extends SqRootScript
{
	function OnSim()
	{
		if(Quest.Get("KeepAllObjects") == 0 && Version.IsEditor() == 0)
		{
			Object.Destroy(self);
		}
	}
}

class CopyProp extends AllYourBase
{
	function OnMessage()
	{
		if(MessageIs(getOnMessage()))
		{	
			local srcParam = GetClassName() + "Source";
			local dstParam = GetClassName() + "Dest";
			local propParam = GetClassName();
			
			local source = getParam(srcParam);
			local dest = getParam(dstParam);
			local prop;
			
			if(propParam in userparams())
			{				
				prop = userparams()[propParam];
				Property.CopyFrom(dest, prop, source);
			}
			else
			{
				DarkUI.TextMessage("\"CopyProp\" parameter not present.");
			}
		}
	}
}

class InvRename extends AllYourBase
{
	function OnMessage()
	{
		if(MessageIs(getOnMessage()))
		{
			local nameParam = GetClassName() + "NewName";
			if(nameParam in userparams())
			{
				Property.SetSimple(self, "gamename", userparams()[nameParam]);
			}
		}
	}
}

class OnOffModels extends AllYourBase
{
	function OnMessage()
	{
		if(MessageIs(getOnMessage()))
		{
			local onModelName = GetClassName() + "SetOn";
			if(onModelName in userparams())
			{
				Property.SetSimple(self, "modelname", userparams()[onModelName]);
			}
		}
		else if(MessageIs(getOffMessage()))
		{
			local offModelName = GetClassName() + "SetOff";
			if(offModelName in userparams())
			{
				Property.SetSimple(self, "modelname", userparams()[offModelName]);
			}
		}
	}
}

//Performs addition, subtraction etc on a quest variable
class QVarArithmetic extends AllYourBase
{
	function setNewValue(qvarCommand) //e.g =1:goal_state_3
	{
		local parts = split(qvarCommand, ":"); //returns array of =1 and goal_state_3
		local lhs = strip(parts[0]); //remove spaces, user might write property like this: =1:goal_state_3; =3:goal_state_4
		local rhs = parts[1];
		
		local qValue = Quest.Get(rhs);
		local userInt = lhs[1].tointeger()-48; //Number entered after the =, + etc
		
		switch(lhs[0])
		{
			case 61:
				qValue = userInt; break;
			case 43:
				qValue += userInt; break;
			case 45:
				qValue -= userInt; break;
			case 42:
				qValue *= userInt; break;
			case 47:
				qValue /= userInt; break;
			case 37:
				qValue %= userInt; break;
			case 33: //!
				qValue = qValue | userInt; break;
			case 124: //|
				qValue = qValue | userInt; break;
			case 123: //{
				qValue = qValue << userInt; break;
			case 125: //}
				qValue = qValue >> userInt; break;
			case 63: //?
				qValue += Data.RandInt(0, userInt); break;
			case 100: //d
				qValue += Data.RandInt(1, userInt); break;
			default:
				print("WARNING: Operator not supported: " + lhs[0].tochar()); 
				DarkUI.TextMessage("Operator not supported: " + lhs[0].tochar(), 0)
				break;
		}
		Quest.Set(rhs, qValue);
	}
}

//Sets a load of qvars specified in the QuestVar propery. Appears instant to the player. Goal text can be overwritten.
class SetMultQVars extends QVarArithmetic
{
	function OnMessage()
	{
		if(MessageIs(getOnMessage()))
		{
			local qvProp = Property.Get(self, "TrapQvar");
			local qvList = split(qvProp, ";");
			
			//qvCommands are like =1:goal_state_3
			foreach(qvCommand in qvList)
			{
				setNewValue(qvCommand);
			}
					
			ShowText();
		}
	}
	
	//Gets the specified entry from playhint.str, or shows the value from the specified book, or shows "New Objectives" by default.
	function ShowText()
	{
		local popup;
		if(HasProperty("DesignNote") && "GoalString" in userparams())
		{
			popup = Data.GetString("PLAYHINT", userparams().GoalString);
		}
		else if ( HasProperty("book") )
		{
			local bookname = GetProperty("book");
			popup = Data.GetString(bookname, "Page_0", "", "Books");
		}
		else
		{
			popup = Data.GetString("PLAYHINT", "NewGoal");
		}
		DarkUI.TextMessage(popup);
	}
}